/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.PublicApi;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import java.util.Objects;

@PublicApi
public class FieldCoordinates {
    private final boolean systemCoordinates;
    private final String typeName;
    private final String fieldName;

    private FieldCoordinates(String typeName, String fieldName, boolean systemCoordinates) {
        this.typeName = typeName;
        this.fieldName = fieldName;
        this.systemCoordinates = systemCoordinates;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void assertValidNames() throws AssertException {
        if (this.systemCoordinates) {
            Assert.assertTrue(null != this.fieldName && this.fieldName.startsWith("__"), () -> "Only __ system fields can be addressed without a parent type");
            Assert.assertValidName(this.fieldName);
        } else {
            Assert.assertValidName(this.typeName);
            Assert.assertValidName(this.fieldName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCoordinates that = (FieldCoordinates)o;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.fieldName);
    }

    public String toString() {
        return this.typeName + ':' + this.fieldName + '\'';
    }

    public static FieldCoordinates coordinates(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition) {
        return new FieldCoordinates(parentType.getName(), fieldDefinition.getName(), false);
    }

    public static FieldCoordinates coordinates(String parentType, String fieldName) {
        return new FieldCoordinates(parentType, fieldName, false);
    }

    public static FieldCoordinates systemCoordinates(String fieldName) {
        return new FieldCoordinates(null, fieldName, true);
    }
}

