/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.Stack;

@PublicApi
public class GraphQLTypeUtil {
    public static String simplePrint(GraphQLType type) {
        Assert.assertNotNull(type, () -> "type can't be null");
        StringBuilder sb = new StringBuilder();
        if (GraphQLTypeUtil.isNonNull(type)) {
            sb.append(GraphQLTypeUtil.simplePrint(GraphQLTypeUtil.unwrapOne(type)));
            sb.append("!");
        } else if (GraphQLTypeUtil.isList(type)) {
            sb.append("[");
            sb.append(GraphQLTypeUtil.simplePrint(GraphQLTypeUtil.unwrapOne(type)));
            sb.append("]");
        } else {
            sb.append(((GraphQLNamedType)type).getName());
        }
        return sb.toString();
    }

    public static String simplePrint(GraphQLSchemaElement schemaElement) {
        if (schemaElement instanceof GraphQLType) {
            return GraphQLTypeUtil.simplePrint((GraphQLType)schemaElement);
        }
        if (schemaElement instanceof GraphQLNamedSchemaElement) {
            return ((GraphQLNamedSchemaElement)schemaElement).getName();
        }
        return (String)Assert.assertShouldNeverHappen("unexpected schema element: " + schemaElement, new Object[0]);
    }

    public static boolean isNonNull(GraphQLType type) {
        return type instanceof GraphQLNonNull;
    }

    public static boolean isNullable(GraphQLType type) {
        return !GraphQLTypeUtil.isNonNull(type);
    }

    public static boolean isList(GraphQLType type) {
        return type instanceof GraphQLList;
    }

    public static boolean isWrapped(GraphQLType type) {
        return GraphQLTypeUtil.isList(type) || GraphQLTypeUtil.isNonNull(type);
    }

    public static boolean isNotWrapped(GraphQLType type) {
        return !GraphQLTypeUtil.isWrapped(type);
    }

    public static boolean isScalar(GraphQLType type) {
        return type instanceof GraphQLScalarType;
    }

    public static boolean isEnum(GraphQLType type) {
        return type instanceof GraphQLEnumType;
    }

    public static boolean isLeaf(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType;
    }

    public static boolean isInput(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType || unmodifiedType instanceof GraphQLInputObjectType;
    }

    public static GraphQLType unwrapOne(GraphQLType type) {
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ((GraphQLNonNull)type).getWrappedType();
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ((GraphQLList)type).getWrappedType();
        }
        return type;
    }

    public static GraphQLUnmodifiedType unwrapAll(GraphQLType type) {
        while (!GraphQLTypeUtil.isNotWrapped(type)) {
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return (GraphQLUnmodifiedType)type;
    }

    public static GraphQLType unwrapNonNull(GraphQLType type) {
        while (GraphQLTypeUtil.isNonNull(type)) {
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return type;
    }

    public static Stack<GraphQLType> unwrapType(GraphQLType type) {
        type = Assert.assertNotNull(type);
        Stack<GraphQLType> decoration = new Stack<GraphQLType>();
        while (true) {
            decoration.push(type);
            if (GraphQLTypeUtil.isNotWrapped(type)) break;
            type = GraphQLTypeUtil.unwrapOne(type);
        }
        return decoration;
    }
}

