/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.Internal;
import graphql.Scalars;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

@Internal
public class PropertyFetchingImpl {
    private final AtomicBoolean USE_SET_ACCESSIBLE = new AtomicBoolean(true);
    private final AtomicBoolean USE_NEGATIVE_CACHE = new AtomicBoolean(true);
    private final ConcurrentMap<String, CachedMethod> METHOD_CACHE = new ConcurrentHashMap<String, CachedMethod>();
    private final ConcurrentMap<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private final ConcurrentMap<String, String> NEGATIVE_CACHE = new ConcurrentHashMap<String, String>();
    private final Class<?> singleArgumentType;

    public PropertyFetchingImpl(Class<?> singleArgumentType) {
        this.singleArgumentType = singleArgumentType;
    }

    public Object getPropertyValue(String propertyName, Object object, GraphQLType graphQLType) {
        return this.getPropertyValue(propertyName, object, graphQLType, null);
    }

    public Object getPropertyValue(String propertyName, Object object, GraphQLType graphQLType, Object singleArgumentValue) {
        Field cachedField;
        if (object instanceof Map) {
            return ((Map)object).get(propertyName);
        }
        String cacheKey = this.mkKey(object, propertyName);
        CachedMethod cachedMethod = (CachedMethod)this.METHOD_CACHE.get(cacheKey);
        if (cachedMethod != null) {
            try {
                return this.invokeMethod(object, singleArgumentValue, cachedMethod.method, cachedMethod.takesSingleArgumentTypeAsOnlyArgument);
            }
            catch (NoSuchMethodException ignored) {
                Assert.assertShouldNeverHappen("A method cached as '%s' is no longer available??", cacheKey);
            }
        }
        if ((cachedField = (Field)this.FIELD_CACHE.get(cacheKey)) != null) {
            return this.invokeField(object, cachedField);
        }
        if (this.isNegativelyCached(cacheKey)) {
            return null;
        }
        boolean dfeInUse = singleArgumentValue != null;
        try {
            MethodFinder methodFinder = (root, methodName) -> this.findPubliclyAccessibleMethod(cacheKey, root, methodName, dfeInUse);
            return this.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder, singleArgumentValue);
        }
        catch (NoSuchMethodException ignored) {
            try {
                MethodFinder methodFinder = (aClass, methodName) -> this.findViaSetAccessible(cacheKey, aClass, methodName, dfeInUse);
                return this.getPropertyViaGetterMethod(object, propertyName, graphQLType, methodFinder, singleArgumentValue);
            }
            catch (NoSuchMethodException ignored2) {
                try {
                    return this.getPropertyViaFieldAccess(cacheKey, object, propertyName);
                }
                catch (FastNoSuchMethodException e) {
                    this.putInNegativeCache(cacheKey);
                    return null;
                }
            }
        }
    }

    private boolean isNegativelyCached(String key) {
        if (this.USE_NEGATIVE_CACHE.get()) {
            return this.NEGATIVE_CACHE.containsKey(key);
        }
        return false;
    }

    private void putInNegativeCache(String key) {
        if (this.USE_NEGATIVE_CACHE.get()) {
            this.NEGATIVE_CACHE.put(key, key);
        }
    }

    private Object getPropertyViaGetterMethod(Object object, String propertyName, GraphQLType graphQLType, MethodFinder methodFinder, Object singleArgumentValue) throws NoSuchMethodException {
        if (this.isBooleanProperty(graphQLType)) {
            try {
                return this.getPropertyViaGetterUsingPrefix(object, propertyName, "is", methodFinder, singleArgumentValue);
            }
            catch (NoSuchMethodException e) {
                return this.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, singleArgumentValue);
            }
        }
        return this.getPropertyViaGetterUsingPrefix(object, propertyName, "get", methodFinder, singleArgumentValue);
    }

    private Object getPropertyViaGetterUsingPrefix(Object object, String propertyName, String prefix, MethodFinder methodFinder, Object singleArgumentValue) throws NoSuchMethodException {
        String getterName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method method = methodFinder.apply(object.getClass(), getterName);
        return this.invokeMethod(object, singleArgumentValue, method, this.takesSingleArgumentTypeAsOnlyArgument(method));
    }

    private Method findPubliclyAccessibleMethod(String cacheKey, Class<?> rootClass, String methodName, boolean dfeInUse) throws NoSuchMethodException {
        for (Class<?> currentClass = rootClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method method;
            if (!Modifier.isPublic(currentClass.getModifiers())) continue;
            if (dfeInUse) {
                try {
                    method = currentClass.getMethod(methodName, this.singleArgumentType);
                    if (Modifier.isPublic(method.getModifiers())) {
                        this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
                        return method;
                    }
                }
                catch (NoSuchMethodException method2) {
                    // empty catch block
                }
            }
            if (!Modifier.isPublic((method = currentClass.getMethod(methodName, new Class[0])).getModifiers())) continue;
            this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
            return method;
        }
        assert (rootClass != null);
        return rootClass.getMethod(methodName, new Class[0]);
    }

    private Method findViaSetAccessible(String cacheKey, Class<?> aClass, String methodName, boolean dfeInUse) throws NoSuchMethodException {
        if (!this.USE_SET_ACCESSIBLE.get()) {
            throw new FastNoSuchMethodException(methodName);
        }
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Predicate<Method> whichMethods = mth -> {
                if (dfeInUse) {
                    return this.hasZeroArgs((Method)mth) || this.takesSingleArgumentTypeAsOnlyArgument((Method)mth);
                }
                return this.hasZeroArgs((Method)mth);
            };
            Method[] declaredMethods = currentClass.getDeclaredMethods();
            Optional<? super Method> m3 = Arrays.stream(declaredMethods).filter(mth -> methodName.equals(mth.getName())).filter(whichMethods).min(PropertyFetchingImpl.mostMethodArgsFirst());
            if (!m3.isPresent()) continue;
            try {
                Method method = m3.get();
                method.setAccessible(true);
                this.METHOD_CACHE.putIfAbsent(cacheKey, new CachedMethod(method));
                return method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new FastNoSuchMethodException(methodName);
    }

    private Object getPropertyViaFieldAccess(String cacheKey, Object object, String propertyName) throws FastNoSuchMethodException {
        Class<?> aClass = object.getClass();
        try {
            Field field = aClass.getField(propertyName);
            this.FIELD_CACHE.putIfAbsent(cacheKey, field);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            if (!this.USE_SET_ACCESSIBLE.get()) {
                throw new FastNoSuchMethodException(cacheKey);
            }
            try {
                Field field = aClass.getDeclaredField(propertyName);
                field.setAccessible(true);
                this.FIELD_CACHE.putIfAbsent(cacheKey, field);
                return field.get(object);
            }
            catch (NoSuchFieldException | SecurityException ignored2) {
                throw new FastNoSuchMethodException(cacheKey);
            }
            catch (IllegalAccessException e1) {
                throw new GraphQLException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private Object invokeMethod(Object object, Object singleArgumentValue, Method method, boolean takesSingleArgument) throws FastNoSuchMethodException {
        try {
            if (takesSingleArgument) {
                if (singleArgumentValue == null) {
                    throw new FastNoSuchMethodException(method.getName());
                }
                return method.invoke(object, singleArgumentValue);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
    }

    private Object invokeField(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLType graphQLType) {
        if (graphQLType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull(graphQLType)) {
            return GraphQLTypeUtil.unwrapOne(graphQLType) == Scalars.GraphQLBoolean;
        }
        return false;
    }

    public void clearReflectionCache() {
        this.METHOD_CACHE.clear();
        this.FIELD_CACHE.clear();
        this.NEGATIVE_CACHE.clear();
    }

    public boolean setUseSetAccessible(boolean flag) {
        return this.USE_SET_ACCESSIBLE.getAndSet(flag);
    }

    public boolean setUseNegativeCache(boolean flag) {
        return this.USE_NEGATIVE_CACHE.getAndSet(flag);
    }

    private String mkKey(Object object, String propertyName) {
        Class<?> clazz = object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader.hashCode() + "__" + clazz.getName() + "__" + propertyName;
        }
        return clazz.getName() + "__" + propertyName;
    }

    private boolean hasZeroArgs(Method mth) {
        return mth.getParameterCount() == 0;
    }

    private boolean takesSingleArgumentTypeAsOnlyArgument(Method mth) {
        return mth.getParameterCount() == 1 && mth.getParameterTypes()[0].equals(this.singleArgumentType);
    }

    private static Comparator<? super Method> mostMethodArgsFirst() {
        return Comparator.comparingInt(Method::getParameterCount).reversed();
    }

    private static class FastNoSuchMethodException
    extends NoSuchMethodException {
        public FastNoSuchMethodException(String methodName) {
            super(methodName);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static interface MethodFinder {
        public Method apply(Class<?> var1, String var2) throws NoSuchMethodException;
    }

    private class CachedMethod {
        Method method;
        boolean takesSingleArgumentTypeAsOnlyArgument;

        CachedMethod(Method method) {
            this.method = method;
            this.takesSingleArgumentTypeAsOnlyArgument = PropertyFetchingImpl.this.takesSingleArgumentTypeAsOnlyArgument(method);
        }
    }
}

