/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLSchemaElementAdapter;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.Breadcrumb;
import graphql.util.NodeAdapter;
import graphql.util.NodeLocation;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class SchemaTransformer {
    public static GraphQLSchema transformSchema(GraphQLSchema schema, GraphQLTypeVisitor visitor) {
        SchemaTransformer schemaTransformer = new SchemaTransformer();
        return schemaTransformer.transform(schema, visitor);
    }

    public GraphQLSchema transform(GraphQLSchema schema, final GraphQLTypeVisitor visitor) {
        final DummyRoot dummyRoot = new DummyRoot(schema);
        final LinkedList<NodeZipper<GraphQLSchemaElement>> zippers = new LinkedList<NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> zipperByNodeAfterTraversing = new LinkedHashMap<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>>();
        final LinkedHashMap zipperByOriginalNode = new LinkedHashMap();
        final LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>>();
        final LinkedHashMap<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies = new LinkedHashMap<GraphQLSchemaElement, List<GraphQLSchemaElement>>();
        TraverserVisitor<GraphQLSchemaElement> nodeTraverserVisitor = new TraverserVisitor<GraphQLSchemaElement>(){

            @Override
            public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
                if (context.thisNode() == dummyRoot) {
                    return TraversalControl.CONTINUE;
                }
                NodeZipper nodeZipper = new NodeZipper(context.thisNode(), context.getBreadcrumbs(), GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                context.setVar(NodeZipper.class, nodeZipper);
                context.setVar(NodeAdapter.class, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
                int zippersBefore = zippers.size();
                TraversalControl result = context.thisNode().accept(context, visitor);
                if (zippersBefore + 1 == zippers.size()) {
                    nodeZipper = (NodeZipper)zippers.get(zippers.size() - 1);
                }
                zipperByOriginalNode.put(context.originalThisNode(), nodeZipper);
                if (context.isDeleted()) {
                    zipperByNodeAfterTraversing.put(context.originalThisNode(), nodeZipper);
                } else {
                    zipperByNodeAfterTraversing.put(context.thisNode(), nodeZipper);
                }
                breadcrumbsByZipper.put(nodeZipper, new ArrayList());
                ((List)breadcrumbsByZipper.get(nodeZipper)).add(context.getBreadcrumbs());
                if (nodeZipper.getModificationType() != NodeZipper.ModificationType.DELETE) {
                    reverseDependencies.computeIfAbsent(context.thisNode(), ign -> new ArrayList()).add(context.getParentNode());
                }
                return result;
            }

            @Override
            public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
                NodeZipper zipper = (NodeZipper)zipperByOriginalNode.get(context.thisNode());
                ((List)breadcrumbsByZipper.get(zipper)).add(context.getBreadcrumbs());
                visitor.visitBackRef(context);
                List reverseDependenciesForCurNode = (List)reverseDependencies.get(zipper.getCurNode());
                Assert.assertNotNull(reverseDependenciesForCurNode);
                reverseDependenciesForCurNode.add(context.getParentNode());
                return TraversalControl.CONTINUE;
            }
        };
        Traverser<GraphQLSchemaElement> traverser = Traverser.depthFirstWithNamedChildren(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER::getNamedChildren, zippers, null);
        GraphQLCodeRegistry.Builder builder = GraphQLCodeRegistry.newCodeRegistry(schema.getCodeRegistry());
        traverser.rootVar(GraphQLCodeRegistry.Builder.class, builder);
        traverser.traverse(dummyRoot, nodeTraverserVisitor);
        List<GraphQLSchemaElement> topologicalSort = this.topologicalSort(zipperByNodeAfterTraversing.keySet(), reverseDependencies);
        this.zipUpToDummyRoot(zippers, topologicalSort, breadcrumbsByZipper, zipperByNodeAfterTraversing);
        GraphQLSchema newSchema = GraphQLSchema.newSchema().query(dummyRoot.query).mutation(dummyRoot.mutation).subscription(dummyRoot.subscription).additionalTypes(dummyRoot.additionalTypes).additionalDirectives(dummyRoot.directives).withSchemaDirectives(dummyRoot.schemaDirectives).codeRegistry(builder.build()).description(schema.getDescription()).buildImpl(true);
        return newSchema;
    }

    private List<GraphQLSchemaElement> topologicalSort(Set<GraphQLSchemaElement> allNodes, Map<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies) {
        Iterator iterator;
        ArrayList<GraphQLSchemaElement> result = new ArrayList<GraphQLSchemaElement>();
        LinkedHashSet<GraphQLSchemaElement> notPermMarked = new LinkedHashSet<GraphQLSchemaElement>(allNodes);
        LinkedHashSet<GraphQLSchemaElement> tempMarked = new LinkedHashSet<GraphQLSchemaElement>();
        LinkedHashSet<GraphQLSchemaElement> permMarked = new LinkedHashSet<GraphQLSchemaElement>();
        while ((iterator = notPermMarked.iterator()).hasNext()) {
            GraphQLSchemaElement n = (GraphQLSchemaElement)iterator.next();
            iterator.remove();
            this.visit(n, tempMarked, permMarked, notPermMarked, result, reverseDependencies);
        }
        return result;
    }

    private void visit(GraphQLSchemaElement n, Set<GraphQLSchemaElement> tempMarked, Set<GraphQLSchemaElement> permMarked, Set<GraphQLSchemaElement> notPermMarked, List<GraphQLSchemaElement> result, Map<GraphQLSchemaElement, List<GraphQLSchemaElement>> reverseDependencies) {
        if (permMarked.contains(n)) {
            return;
        }
        if (tempMarked.contains(n)) {
            Assert.assertShouldNeverHappen("NOT A DAG: %s has temp mark", n);
            return;
        }
        tempMarked.add(n);
        if (reverseDependencies.containsKey(n)) {
            for (GraphQLSchemaElement m3 : reverseDependencies.get(n)) {
                this.visit(m3, tempMarked, permMarked, notPermMarked, result, reverseDependencies);
            }
        }
        tempMarked.remove(n);
        permMarked.add(n);
        notPermMarked.remove(n);
        result.add(n);
    }

    private void zipUpToDummyRoot(List<NodeZipper<GraphQLSchemaElement>> zippers, List<GraphQLSchemaElement> topSort, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> breadcrumbsByZipper, Map<GraphQLSchemaElement, NodeZipper<GraphQLSchemaElement>> nodeToZipper) {
        if (zippers.size() == 0) {
            return;
        }
        LinkedHashSet<NodeZipper<GraphQLSchemaElement>> curZippers = new LinkedHashSet<NodeZipper<GraphQLSchemaElement>>(zippers);
        for (int i = topSort.size() - 1; i >= 0; --i) {
            GraphQLSchemaElement element = topSort.get(i);
            Map<NodeZipper<GraphQLSchemaElement>, List<Breadcrumb<GraphQLSchemaElement>>> zipperWithSameParent = this.zipperWithSameParent(element, curZippers, breadcrumbsByZipper);
            if (zipperWithSameParent.size() == 0) continue;
            NodeZipper<GraphQLSchemaElement> newZipper = this.moveUp(element, zipperWithSameParent);
            if (element instanceof DummyRoot) break;
            NodeZipper<GraphQLSchemaElement> curZipperForElement = nodeToZipper.get(element);
            Assert.assertNotNull(curZipperForElement, () -> String.format("curZipperForElement is null for parentNode %s", element));
            curZippers.remove(curZipperForElement);
            curZippers.add(newZipper);
            List<List<Breadcrumb<GraphQLSchemaElement>>> breadcrumbsForOriginalParent = breadcrumbsByZipper.get(curZipperForElement);
            Assert.assertNotNull(breadcrumbsForOriginalParent, () -> String.format("No breadcrumbs found for zipper %s", curZipperForElement));
            breadcrumbsByZipper.remove(curZipperForElement);
            breadcrumbsByZipper.put(newZipper, breadcrumbsForOriginalParent);
        }
    }

    private Map<NodeZipper<GraphQLSchemaElement>, List<Breadcrumb<GraphQLSchemaElement>>> zipperWithSameParent(GraphQLSchemaElement parent, Set<NodeZipper<GraphQLSchemaElement>> zippers, Map<NodeZipper<GraphQLSchemaElement>, List<List<Breadcrumb<GraphQLSchemaElement>>>> curBreadcrumbsByZipper) {
        LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<Breadcrumb<GraphQLSchemaElement>>> result = new LinkedHashMap<NodeZipper<GraphQLSchemaElement>, List<Breadcrumb<GraphQLSchemaElement>>>();
        block0: for (NodeZipper<GraphQLSchemaElement> zipper : zippers) {
            for (List<Breadcrumb<GraphQLSchemaElement>> path : curBreadcrumbsByZipper.get(zipper)) {
                if (path.get(0).getNode() != parent) continue;
                result.put(zipper, path);
                continue block0;
            }
        }
        return result;
    }

    private NodeZipper<GraphQLSchemaElement> moveUp(GraphQLSchemaElement parent, Map<NodeZipper<GraphQLSchemaElement>, List<Breadcrumb<GraphQLSchemaElement>>> sameParentsZipper) {
        Set<NodeZipper<GraphQLSchemaElement>> sameParent = sameParentsZipper.keySet();
        Assert.assertNotEmpty(sameParent, () -> "expected at least one zipper");
        HashMap<String, List<GraphQLSchemaElement>> childrenMap = new HashMap<String, List<GraphQLSchemaElement>>(GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.getNamedChildren(parent));
        HashMap<String, Integer> indexCorrection = new HashMap<String, Integer>();
        ArrayList<ZipperWithOneParent> zipperWithOneParents = new ArrayList<ZipperWithOneParent>();
        for (NodeZipper<GraphQLSchemaElement> zipper : sameParent) {
            List<Breadcrumb<GraphQLSchemaElement>> breadcrumbs = sameParentsZipper.get(zipper);
            zipperWithOneParents.add(new ZipperWithOneParent(zipper, breadcrumbs.get(0)));
        }
        zipperWithOneParents.sort((zipperWithOneParent1, zipperWithOneParent2) -> {
            NodeZipper.ModificationType modificationType2;
            int index2;
            NodeZipper<GraphQLSchemaElement> zipper1 = zipperWithOneParent1.zipper;
            NodeZipper<GraphQLSchemaElement> zipper2 = zipperWithOneParent2.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb1 = zipperWithOneParent1.parent;
            Breadcrumb<GraphQLSchemaElement> breadcrumb2 = zipperWithOneParent2.parent;
            int index1 = breadcrumb1.getLocation().getIndex();
            if (index1 != (index2 = breadcrumb2.getLocation().getIndex())) {
                return Integer.compare(index1, index2);
            }
            NodeZipper.ModificationType modificationType1 = zipper1.getModificationType();
            if (modificationType1 == (modificationType2 = zipper2.getModificationType())) {
                return 0;
            }
            if (modificationType1 == NodeZipper.ModificationType.REPLACE) {
                return -1;
            }
            return modificationType1 == NodeZipper.ModificationType.INSERT_BEFORE ? -1 : 1;
        });
        for (ZipperWithOneParent zipperWithOneParent : zipperWithOneParents) {
            NodeZipper<GraphQLSchemaElement> zipper = zipperWithOneParent.zipper;
            Breadcrumb<GraphQLSchemaElement> breadcrumb = zipperWithOneParent.parent;
            NodeLocation location = breadcrumb.getLocation();
            Integer ixDiff = indexCorrection.getOrDefault(location.getName(), 0);
            int ix = location.getIndex() + ixDiff;
            String name = location.getName();
            ArrayList<GraphQLSchemaElement> childList = new ArrayList<GraphQLSchemaElement>((Collection)childrenMap.get(name));
            switch (zipper.getModificationType()) {
                case REPLACE: {
                    childList.set(ix, zipper.getCurNode());
                    break;
                }
                case DELETE: {
                    childList.remove(ix);
                    indexCorrection.put(name, ixDiff - 1);
                    break;
                }
                case INSERT_BEFORE: {
                    childList.add(ix, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                    break;
                }
                case INSERT_AFTER: {
                    childList.add(ix + 1, zipper.getCurNode());
                    indexCorrection.put(name, ixDiff + 1);
                }
            }
            childrenMap.put(name, childList);
        }
        GraphQLSchemaElement newNode = GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER.withNewChildren(parent, (Map<String, List<GraphQLSchemaElement>>)childrenMap);
        List<Breadcrumb<GraphQLSchemaElement>> oldBreadcrumbs = sameParent.iterator().next().getBreadcrumbs();
        List<Object> newBreadcrumbs = oldBreadcrumbs.size() > 1 ? oldBreadcrumbs.subList(1, oldBreadcrumbs.size()) : Collections.emptyList();
        return new NodeZipper<GraphQLSchemaElement>(newNode, newBreadcrumbs, GraphQLSchemaElementAdapter.SCHEMA_ELEMENT_ADAPTER);
    }

    private static class ZipperWithOneParent {
        public NodeZipper<GraphQLSchemaElement> zipper;
        public Breadcrumb<GraphQLSchemaElement> parent;

        public ZipperWithOneParent(NodeZipper<GraphQLSchemaElement> zipper, Breadcrumb<GraphQLSchemaElement> parent) {
            this.zipper = zipper;
            this.parent = parent;
        }
    }

    private static class DummyRoot
    implements GraphQLSchemaElement {
        static final String QUERY = "query";
        static final String MUTATION = "mutation";
        static final String SUBSCRIPTION = "subscription";
        static final String ADD_TYPES = "addTypes";
        static final String DIRECTIVES = "directives";
        static final String SCHEMA_DIRECTIVES = "schemaDirectives";
        static final String INTROSPECTION = "introspection";
        GraphQLSchema schema;
        GraphQLObjectType query;
        GraphQLObjectType mutation;
        GraphQLObjectType subscription;
        Set<GraphQLType> additionalTypes;
        Set<GraphQLDirective> directives;
        Set<GraphQLDirective> schemaDirectives;

        DummyRoot(GraphQLSchema schema) {
            this.schema = schema;
            this.query = schema.getQueryType();
            this.mutation = schema.isSupportingMutations() ? schema.getMutationType() : null;
            this.subscription = schema.isSupportingSubscriptions() ? schema.getSubscriptionType() : null;
            this.additionalTypes = schema.getAdditionalTypes();
            this.schemaDirectives = new LinkedHashSet<GraphQLDirective>(schema.getSchemaDirectives());
            this.directives = new LinkedHashSet<GraphQLDirective>(schema.getDirectives());
        }

        @Override
        public List<GraphQLSchemaElement> getChildren() {
            return (List)Assert.assertShouldNeverHappen();
        }

        @Override
        public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
            SchemaElementChildrenContainer.Builder builder = SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(QUERY, this.query);
            if (this.schema.isSupportingMutations()) {
                builder.child(MUTATION, this.mutation);
            }
            if (this.schema.isSupportingSubscriptions()) {
                builder.child(SUBSCRIPTION, this.subscription);
            }
            builder.children(ADD_TYPES, this.additionalTypes);
            builder.children(DIRECTIVES, this.directives);
            builder.children(SCHEMA_DIRECTIVES, this.schemaDirectives);
            builder.child(INTROSPECTION, Introspection.__Schema);
            return builder.build();
        }

        @Override
        public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
            this.query = (GraphQLObjectType)newChildren.getChildOrNull(QUERY);
            this.mutation = (GraphQLObjectType)newChildren.getChildOrNull(MUTATION);
            this.subscription = (GraphQLObjectType)newChildren.getChildOrNull(SUBSCRIPTION);
            this.additionalTypes = new LinkedHashSet(newChildren.getChildren(ADD_TYPES));
            this.directives = new LinkedHashSet(newChildren.getChildren(DIRECTIVES));
            this.schemaDirectives = new LinkedHashSet(newChildren.getChildren(SCHEMA_DIRECTIVES));
            return this;
        }

        @Override
        public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
            return (TraversalControl)((Object)Assert.assertShouldNeverHappen());
        }
    }
}

