/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.language.Node;
import graphql.language.OperationTypeDefinition;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiringSchemaGeneratorPostProcessing;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaGeneratorHelper;
import graphql.schema.idl.SchemaGeneratorPostProcessing;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class SchemaGenerator {
    private final SchemaTypeChecker typeChecker = new SchemaTypeChecker();
    private final SchemaGeneratorHelper schemaGeneratorHelper = new SchemaGeneratorHelper();

    public GraphQLSchema makeExecutableSchema(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        return this.makeExecutableSchema(Options.defaultOptions(), typeRegistry, wiring);
    }

    public GraphQLSchema makeExecutableSchema(Options options, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        TypeDefinitionRegistry typeRegistryCopy = new TypeDefinitionRegistry();
        typeRegistryCopy.merge(typeRegistry);
        this.schemaGeneratorHelper.addDirectivesIncludedByDefault(typeRegistryCopy);
        List<GraphQLError> errors = this.typeChecker.checkTypeRegistry(typeRegistryCopy, wiring);
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        Map<String, OperationTypeDefinition> operationTypeDefinitions = SchemaExtensionsChecker.gatherOperationDefs(typeRegistry);
        return this.makeExecutableSchemaImpl(typeRegistryCopy, wiring, operationTypeDefinitions);
    }

    private GraphQLSchema makeExecutableSchemaImpl(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions) {
        SchemaGeneratorHelper.BuildContext buildCtx = new SchemaGeneratorHelper.BuildContext(typeRegistry, wiring, operationTypeDefinitions);
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        Set<GraphQLDirective> additionalDirectives = this.schemaGeneratorHelper.buildAdditionalDirectives(buildCtx);
        schemaBuilder.additionalDirectives(additionalDirectives);
        this.schemaGeneratorHelper.buildSchemaDirectivesAndExtensions(buildCtx, schemaBuilder);
        this.schemaGeneratorHelper.buildOperations(buildCtx, schemaBuilder);
        Set<GraphQLType> additionalTypes = this.schemaGeneratorHelper.buildAdditionalTypes(buildCtx);
        schemaBuilder.additionalTypes(additionalTypes);
        buildCtx.getCodeRegistry().fieldVisibility(buildCtx.getWiring().getFieldVisibility());
        GraphQLCodeRegistry codeRegistry = buildCtx.getCodeRegistry().build();
        schemaBuilder.codeRegistry(codeRegistry);
        buildCtx.getTypeRegistry().schemaDefinition().ifPresent(schemaDefinition -> {
            String description = this.schemaGeneratorHelper.buildDescription((Node<?>)schemaDefinition, schemaDefinition.getDescription());
            schemaBuilder.description(description);
        });
        GraphQLSchema graphQLSchema = schemaBuilder.build();
        ArrayList<SchemaGeneratorPostProcessing> schemaTransformers = new ArrayList<SchemaGeneratorPostProcessing>();
        schemaTransformers.add(new SchemaDirectiveWiringSchemaGeneratorPostProcessing(buildCtx.getTypeRegistry(), buildCtx.getWiring(), buildCtx.getCodeRegistry()));
        schemaTransformers.addAll(buildCtx.getWiring().getSchemaGeneratorPostProcessings());
        for (SchemaGeneratorPostProcessing postProcessing : schemaTransformers) {
            graphQLSchema = postProcessing.process(graphQLSchema);
        }
        return graphQLSchema;
    }

    public static class Options {
        Options() {
        }

        public static Options defaultOptions() {
            return new Options();
        }
    }
}

