/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.AssertException;
import graphql.Directives;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.DirectivesContainer;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.util.FpKit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
public class SchemaGeneratorHelper {
    static final String NO_LONGER_SUPPORTED = "No longer supported";
    static final DirectiveDefinition DEPRECATED_DIRECTIVE_DEFINITION = DirectiveDefinition.newDirectiveDefinition().name(Directives.DeprecatedDirective.getName()).directiveLocation(DirectiveLocation.newDirectiveLocation().name(Introspection.DirectiveLocation.FIELD_DEFINITION.name()).build()).directiveLocation(DirectiveLocation.newDirectiveLocation().name(Introspection.DirectiveLocation.ENUM_VALUE.name()).build()).description(SchemaGeneratorHelper.createDescription("Marks the field or enum value as deprecated")).inputValueDefinition(InputValueDefinition.newInputValueDefinition().name("reason").description(SchemaGeneratorHelper.createDescription("The reason for the deprecation")).type(TypeName.newTypeName().name("String").build()).defaultValue(StringValue.newStringValue().value("No longer supported").build()).build()).build();
    static final DirectiveDefinition SPECIFIED_BY_DIRECTIVE_DEFINITION = DirectiveDefinition.newDirectiveDefinition().name(Directives.SpecifiedByDirective.getName()).directiveLocation(DirectiveLocation.newDirectiveLocation().name(Introspection.DirectiveLocation.SCALAR.name()).build()).description(SchemaGeneratorHelper.createDescription("Exposes a URL that specifies the behaviour of this scalar.")).inputValueDefinition(InputValueDefinition.newInputValueDefinition().name("url").description(SchemaGeneratorHelper.createDescription("The URL that specifies the behaviour of this scalar.")).type(NonNullType.newNonNullType(TypeName.newTypeName().name("String").build()).build()).build()).build();

    private static Description createDescription(String s2) {
        return new Description(s2, null, false);
    }

    Object buildValue(Value value, GraphQLType requiredType) {
        if (value == null || value instanceof NullValue) {
            return null;
        }
        if (GraphQLTypeUtil.isNonNull(requiredType)) {
            requiredType = GraphQLTypeUtil.unwrapOne(requiredType);
        }
        Object result = null;
        if (requiredType instanceof GraphQLScalarType) {
            result = this.parseLiteral(value, (GraphQLScalarType)requiredType);
        } else if (requiredType instanceof GraphQLEnumType && value instanceof EnumValue) {
            result = ((EnumValue)value).getName();
        } else if (requiredType instanceof GraphQLEnumType && value instanceof StringValue) {
            result = ((StringValue)value).getValue();
        } else if (GraphQLTypeUtil.isList(requiredType)) {
            result = value instanceof ArrayValue ? this.buildArrayValue(requiredType, (ArrayValue)value) : this.buildArrayValue(requiredType, ArrayValue.newArrayValue().value(value).build());
        } else if (value instanceof ObjectValue && requiredType instanceof GraphQLInputObjectType) {
            result = this.buildObjectValue((ObjectValue)value, (GraphQLInputObjectType)requiredType);
        } else {
            Assert.assertShouldNeverHappen("cannot build value of type %s from object class %s with instance %s", GraphQLTypeUtil.simplePrint(requiredType), value.getClass().getSimpleName(), String.valueOf(value));
        }
        return result;
    }

    private Object parseLiteral(Value value, GraphQLScalarType requiredType) {
        return requiredType.getCoercing().parseLiteral(value);
    }

    Object buildArrayValue(GraphQLType requiredType, ArrayValue arrayValue) {
        GraphQLType wrappedType = GraphQLTypeUtil.unwrapOne(requiredType);
        ImmutableList<Object> result = ImmutableKit.map(arrayValue.getValues(), item -> this.buildValue((Value)item, wrappedType));
        return result;
    }

    Object buildObjectValue(ObjectValue defaultValue, GraphQLInputObjectType objectType) {
        LinkedHashMap map = new LinkedHashMap();
        objectType.getFieldDefinitions().forEach(f -> {
            Value<?> fieldValueFromDefaultObjectValue = this.getFieldValueFromObjectValue(defaultValue, f.getName());
            map.put(f.getName(), fieldValueFromDefaultObjectValue != null ? this.buildValue(fieldValueFromDefaultObjectValue, f.getType()) : f.getDefaultValue());
        });
        return map;
    }

    Value<?> getFieldValueFromObjectValue(ObjectValue objectValue, String fieldName) {
        return objectValue.getObjectFields().stream().filter(dvf -> dvf.getName().equals(fieldName)).map(ObjectField::getValue).findFirst().orElse(null);
    }

    String buildDescription(Node<?> node, Description description) {
        if (description != null) {
            return description.getContent();
        }
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = Optional.ofNullable(directives).orElse(Collections.emptyList())).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return NO_LONGER_SUPPORTED;
            }
            return args.get("reason");
        }
        return null;
    }

    private GraphQLDirective buildDirective(BuildContext buildCtx, Directive directive, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> runtimeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry, Set<String> previousNames) {
        GraphQLDirective gqlDirective = this.buildDirective(buildCtx, directive, runtimeDirectives, directiveLocation, comparatorRegistry);
        if (previousNames.contains(directive.getName())) {
            Assert.assertTrue(gqlDirective.isRepeatable(), () -> String.format("The directive '%s' MUST be defined as a repeatable directive if its repeated on an SDL element", directive.getName()));
        }
        previousNames.add(gqlDirective.getName());
        return gqlDirective;
    }

    GraphQLDirective buildDirective(BuildContext buildCtx, Directive directive, Set<GraphQLDirective> directiveDefinitions, Introspection.DirectiveLocation directiveLocation, GraphqlTypeComparatorRegistry comparatorRegistry) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(this.buildDescription(directive, null)).comparatorRegistry(comparatorRegistry).validLocations(directiveLocation);
        Optional<GraphQLDirective> directiveDefOpt = FpKit.findOne(directiveDefinitions, dd -> dd.getName().equals(directive.getName()));
        GraphQLDirective graphQLDirective = directiveDefOpt.orElseGet(() -> {
            Function<Type, GraphQLInputType> inputTypeFactory = inputType -> this.buildInputType(buildCtx, (Type)inputType);
            return this.buildDirectiveFromDefinition(buildCtx.getTypeRegistry().getDirectiveDefinition(directive.getName()).get(), inputTypeFactory);
        });
        builder.repeatable(graphQLDirective.isRepeatable());
        List<GraphQLArgument> arguments = ImmutableKit.map(directive.getArguments(), arg -> this.buildDirectiveArgument((Argument)arg, graphQLDirective));
        arguments = this.transferMissingArguments(arguments, graphQLDirective);
        arguments.forEach(builder::argument);
        return builder.build();
    }

    private GraphQLArgument buildDirectiveArgument(Argument arg, GraphQLDirective directiveDefinition) {
        GraphQLArgument directiveDefArgument = directiveDefinition.getArgument(arg.getName());
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(arg.getName());
        GraphQLInputType inputType = directiveDefArgument.getType();
        Object defaultValue = directiveDefArgument.getDefaultValue();
        builder.type(inputType);
        builder.defaultValue(defaultValue);
        Object value = this.buildValue(arg.getValue(), inputType);
        builder.value(value == null ? defaultValue : value);
        return builder.build();
    }

    private List<GraphQLArgument> transferMissingArguments(List<GraphQLArgument> arguments, GraphQLDirective directiveDefinition) {
        Map<String, GraphQLArgument> declaredArgs = FpKit.getByName(arguments, GraphQLArgument::getName, FpKit.mergeFirst());
        ArrayList<GraphQLArgument> argumentsOut = new ArrayList<GraphQLArgument>(arguments);
        for (GraphQLArgument directiveDefArg : directiveDefinition.getArguments()) {
            if (declaredArgs.containsKey(directiveDefArg.getName())) continue;
            GraphQLArgument missingArg = GraphQLArgument.newArgument().name(directiveDefArg.getName()).description(directiveDefArg.getDescription()).definition(directiveDefArg.getDefinition()).type(directiveDefArg.getType()).defaultValue(directiveDefArg.getDefaultValue()).value(directiveDefArg.getDefaultValue()).build();
            argumentsOut.add(missingArg);
        }
        return argumentsOut;
    }

    GraphQLDirective buildDirectiveFromDefinition(DirectiveDefinition directiveDefinition, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directiveDefinition.getName()).definition(directiveDefinition).repeatable(directiveDefinition.isRepeatable()).description(this.buildDescription(directiveDefinition, directiveDefinition.getDescription()));
        List<Introspection.DirectiveLocation> locations = this.buildLocations(directiveDefinition);
        locations.forEach(xva$0 -> builder.validLocations((Introspection.DirectiveLocation)((Object)xva$0)));
        ImmutableList<GraphQLArgument> arguments = ImmutableKit.map(directiveDefinition.getInputValueDefinitions(), arg -> this.buildDirectiveArgumentFromDefinition((InputValueDefinition)arg, inputTypeFactory));
        arguments.forEach(builder::argument);
        return builder.build();
    }

    private List<Introspection.DirectiveLocation> buildLocations(DirectiveDefinition directiveDefinition) {
        return ImmutableKit.map(directiveDefinition.getDirectiveLocations(), dl -> Introspection.DirectiveLocation.valueOf(dl.getName().toUpperCase()));
    }

    private GraphQLArgument buildDirectiveArgumentFromDefinition(InputValueDefinition arg, Function<Type, GraphQLInputType> inputTypeFactory) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument().name(arg.getName()).definition(arg);
        GraphQLInputType inputType = inputTypeFactory.apply(arg.getType());
        builder.type(inputType);
        builder.value(this.buildValue(arg.getDefaultValue(), inputType));
        builder.defaultValue(this.buildValue(arg.getDefaultValue(), inputType));
        builder.description(this.buildDescription(arg, arg.getDescription()));
        return builder.build();
    }

    GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(rawType, typeDefinition);
        }
        buildCtx.putInputType((GraphQLNamedInputType)inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InputObjectTypeExtensionDefinition> extensions = this.inputObjectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.INPUT_OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getInputValueDefinitions().forEach(inputValue -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)inputValue)));
        extensions.forEach(extension -> extension.getInputValueDefinitions().forEach(inputValueDefinition -> {
            GraphQLInputObjectField inputField = this.buildInputField(buildCtx, (InputValueDefinition)inputValueDefinition);
            if (!builder.hasField(inputField.getName())) {
                builder.field(inputField);
            }
        }));
        return builder.build();
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(fieldDef);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(this.buildDescription(fieldDef, fieldDef.getDescription()));
        fieldBuilder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        Value defaultValue = fieldDef.getDefaultValue();
        if (defaultValue != null) {
            fieldBuilder.defaultValue(this.buildValue(defaultValue, inputType));
        }
        fieldBuilder.withDirectives(this.buildDirectives(buildCtx, fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return fieldBuilder.build();
    }

    GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<EnumTypeExtensionDefinition> extensions = this.enumTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            builder.value(enumValueDefinition);
        });
        extensions.forEach(extension -> extension.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            if (!builder.hasValue(enumValueDefinition.getName())) {
                builder.value(enumValueDefinition);
            }
        }));
        builder.withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.ENUM, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return builder.build();
    }

    private GraphQLEnumValueDefinition buildEnumValue(BuildContext buildCtx, EnumTypeDefinition typeDefinition, EnumValuesProvider enumValuesProvider, EnumValueDefinition evd) {
        Object value;
        String description = this.buildDescription(evd, evd.getDescription());
        String deprecation = this.buildDeprecationReason(evd.getDirectives());
        if (enumValuesProvider != null) {
            value = enumValuesProvider.getValue(evd.getName());
            Assert.assertNotNull(value, () -> String.format("EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName()));
        } else {
            value = evd.getName();
        }
        return GraphQLEnumValueDefinition.newEnumValueDefinition().name(evd.getName()).value(value).description(description).deprecationReason(deprecation).definition(evd).comparatorRegistry(buildCtx.getComparatorRegistry()).withDirectives(this.buildDirectives(buildCtx, evd.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ENUM_VALUE, buildCtx.getDirectives(), buildCtx.getComparatorRegistry())).build();
    }

    GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        List<ScalarTypeExtensionDefinition> extensions;
        ScalarWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        GraphQLScalarType scalar = wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, typeDefinition, extensions = this.scalarTypeExtensions(typeDefinition, buildCtx))) ? wiringFactory.getScalar(environment) : buildCtx.getWiring().getScalars().get(typeDefinition.getName());
        if (!ScalarInfo.isGraphqlSpecifiedScalar(scalar)) {
            scalar = scalar.transform(builder -> builder.definition(typeDefinition).comparatorRegistry(buildCtx.getComparatorRegistry()).specifiedByUrl(this.getSpecifiedByUrl(typeDefinition, extensions)).withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.SCALAR, buildCtx.getDirectives(), buildCtx.getComparatorRegistry())));
        }
        return scalar;
    }

    String getSpecifiedByUrl(ScalarTypeDefinition scalarTypeDefinition, List<ScalarTypeExtensionDefinition> extensions) {
        ArrayList<Directive> allDirectives = new ArrayList<Directive>(scalarTypeDefinition.getDirectives());
        extensions.forEach(extension -> allDirectives.addAll(extension.getDirectives()));
        Optional<Directive> specifiedByDirective = FpKit.findOne(allDirectives, directiveDefinition -> directiveDefinition.getName().equals(Directives.SpecifiedByDirective.getName()));
        if (!specifiedByDirective.isPresent()) {
            return null;
        }
        Argument urlArgument = specifiedByDirective.get().getArgument("url");
        StringValue url = (StringValue)urlArgument.getValue();
        return url.getValue();
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it provides a interface type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, () -> "The WiringFactory indicated it union provides a type resolver but then returned null");
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    GraphQLDirective[] buildDirectives(BuildContext buildCtx, List<Directive> directives, List<Directive> extensionDirectives, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> runtimeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry) {
        GraphQLDirective gqlDirective;
        directives = Optional.ofNullable(directives).orElse(Collections.emptyList());
        extensionDirectives = Optional.ofNullable(extensionDirectives).orElse(Collections.emptyList());
        LinkedHashSet<String> previousNames = new LinkedHashSet<String>();
        ArrayList<GraphQLDirective> output = new ArrayList<GraphQLDirective>();
        for (Directive directive : directives) {
            gqlDirective = this.buildDirective(buildCtx, directive, directiveLocation, runtimeDirectives, comparatorRegistry, previousNames);
            output.add(gqlDirective);
        }
        for (Directive directive : extensionDirectives) {
            gqlDirective = this.buildDirective(buildCtx, directive, directiveLocation, runtimeDirectives, comparatorRegistry, previousNames);
            output.add(gqlDirective);
        }
        return output.toArray(new GraphQLDirective[0]);
    }

    private void buildInterfaceTypeInterfaces(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition, GraphQLInterfaceType.Builder builder, List<InterfaceTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        TypeName type = operation.getTypeName();
        return (GraphQLObjectType)this.buildOutputType(buildCtx, type);
    }

    GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<InterfaceTypeExtensionDefinition> extensions = this.interfaceTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildInterfaceTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        GraphQLInterfaceType interfaceType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(interfaceType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForInterface(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(interfaceType, typeResolver);
        }
        return interfaceType;
    }

    GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<ObjectTypeExtensionDefinition> extensions = this.objectTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        builder.withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(fieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition fieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(fieldDefinition.getName())) {
                builder.field(fieldDefinition);
            }
        }));
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        return builder.build();
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<ObjectTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLNamedOutputType newInterfaceType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(interfaze -> {
            if (interfaze instanceof GraphQLInterfaceType) {
                builder.withInterface((GraphQLInterfaceType)interfaze);
                return;
            }
            if (interfaze instanceof GraphQLTypeReference) {
                builder.withInterface((GraphQLTypeReference)interfaze);
            }
        });
    }

    GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        List<UnionTypeExtensionDefinition> extensions = this.unionTypeExtensions(typeDefinition, buildCtx);
        builder.extensionDefinitions(extensions);
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        builder.withDirectives(this.buildDirectives(buildCtx, typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.UNION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        extensions.forEach(extension -> extension.getMemberTypes().forEach(mt -> {
            GraphQLNamedOutputType outputType = (GraphQLNamedOutputType)this.buildOutputType(buildCtx, (Type)mt);
            if (!builder.containType(outputType.getName())) {
                if (outputType instanceof GraphQLTypeReference) {
                    builder.possibleType((GraphQLTypeReference)outputType);
                } else {
                    builder.possibleType((GraphQLObjectType)outputType);
                }
            }
        }));
        GraphQLUnionType unionType = builder.build();
        if (!buildCtx.getCodeRegistry().hasTypeResolver(unionType.getName())) {
            TypeResolver typeResolver = this.getTypeResolverForUnion(buildCtx, typeDefinition);
            buildCtx.getCodeRegistry().typeResolver(unionType, typeResolver);
        }
        return unionType;
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(rawType, typeDefinition);
        }
        buildCtx.putOutputType((GraphQLNamedOutputType)outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(fieldDef);
        builder.name(fieldDef.getName());
        builder.description(this.buildDescription(fieldDef, fieldDef.getDescription()));
        builder.deprecate(this.buildDeprecationReason(fieldDef.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLDirective[] directives = this.buildDirectives(buildCtx, fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.FIELD_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        builder.withDirectives(directives);
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object fieldType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)fieldType);
        GraphQLFieldDefinition fieldDefinition = builder.build();
        FieldCoordinates coordinates = FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName());
        if (!buildCtx.getCodeRegistry().hasDataFetcher(coordinates)) {
            DataFetcherFactory dataFetcherFactory = this.buildDataFetcherFactory(buildCtx, parentType, fieldDef, (GraphQLOutputType)fieldType, Arrays.asList(directives));
            buildCtx.getCodeRegistry().dataFetcher(coordinates, dataFetcherFactory);
        }
        return fieldDefinition;
    }

    private DataFetcherFactory buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef, GraphQLOutputType fieldType, List<GraphQLDirective> directives) {
        DataFetcherFactory dataFetcherFactory;
        FieldWiringEnvironment wiringEnvironment;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef, fieldType, directives))) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, () -> "The WiringFactory indicated it provides a data fetcher factory but then returned null");
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, () -> "The WiringFactory indicated it provides a data fetcher but then returned null");
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null && (dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment)) == null) {
                    dataFetcher = this.dataFetcherOfLastResort(wiringEnvironment);
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(valueDefinition);
        builder.name(valueDefinition.getName());
        builder.description(this.buildDescription(valueDefinition, valueDefinition.getDescription()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        Value defaultValue = valueDefinition.getDefaultValue();
        if (defaultValue != null) {
            builder.defaultValue(this.buildValue(defaultValue, inputType));
        }
        builder.withDirectives(this.buildDirectives(buildCtx, valueDefinition.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ARGUMENT_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry()));
        return builder.build();
    }

    void buildOperations(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType query;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        Map<String, OperationTypeDefinition> operationTypeDefs = buildCtx.operationTypeDefs;
        Optional<OperationTypeDefinition> queryOperation = this.getOperationNamed("query", operationTypeDefs);
        if (!queryOperation.isPresent()) {
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            query = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(queryTypeDef.getName()).build());
        } else {
            query = this.buildOperation(buildCtx, queryOperation.get());
        }
        schemaBuilder.query(query);
        Optional<OperationTypeDefinition> mutationOperation = this.getOperationNamed("mutation", operationTypeDefs);
        if (!mutationOperation.isPresent()) {
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(mutationTypeDef.get().getName()).build());
                schemaBuilder.mutation(mutation);
            }
        } else {
            GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOperation.get());
            schemaBuilder.mutation(mutation);
        }
        Optional<OperationTypeDefinition> subscriptionOperation = this.getOperationNamed("subscription", operationTypeDefs);
        if (!subscriptionOperation.isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef = typeRegistry.getType("Subscription");
            if (subscriptionTypeDef.isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, TypeName.newTypeName().name(subscriptionTypeDef.get().getName()).build());
                schemaBuilder.subscription(subscription);
            }
        } else {
            GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOperation.get());
            schemaBuilder.subscription(subscription);
        }
    }

    void buildSchemaDirectivesAndExtensions(BuildContext buildCtx, GraphQLSchema.Builder schemaBuilder) {
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        List<Directive> schemaDirectiveList = SchemaExtensionsChecker.gatherSchemaDirectives(typeRegistry);
        Set<GraphQLDirective> runtimeDirectives = buildCtx.getDirectives();
        schemaBuilder.withSchemaDirectives(this.buildDirectives(buildCtx, schemaDirectiveList, Collections.emptyList(), Introspection.DirectiveLocation.SCHEMA, runtimeDirectives, buildCtx.getComparatorRegistry()));
        schemaBuilder.definition(typeRegistry.schemaDefinition().orElse(null));
        schemaBuilder.extensionDefinitions(typeRegistry.getSchemaExtensionDefinitions());
    }

    List<InputObjectTypeExtensionDefinition> inputObjectTypeExtensions(InputObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().inputObjectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<EnumTypeExtensionDefinition> enumTypeExtensions(EnumTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().enumTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ScalarTypeExtensionDefinition> scalarTypeExtensions(ScalarTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().scalarTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<InterfaceTypeExtensionDefinition> interfaceTypeExtensions(InterfaceTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().interfaceTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<ObjectTypeExtensionDefinition> objectTypeExtensions(ObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().objectTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    List<UnionTypeExtensionDefinition> unionTypeExtensions(UnionTypeDefinition typeDefinition, BuildContext buildCtx) {
        return buildCtx.getTypeRegistry().unionTypeExtensions().getOrDefault(typeDefinition.getName(), Collections.emptyList());
    }

    Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        LinkedHashSet<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        typeRegistry.types().values().forEach(typeDefinition -> {
            TypeName typeName = TypeName.newTypeName().name(typeDefinition.getName()).build();
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition)typeDefinition) == null) {
                    additionalTypes.add(this.buildInputType(buildCtx, typeName));
                }
            } else if (buildCtx.hasOutputType((TypeDefinition)typeDefinition) == null) {
                additionalTypes.add((GraphQLType)this.buildOutputType(buildCtx, typeName));
            }
        });
        typeRegistry.scalars().values().forEach(scalarTypeDefinition -> {
            if (ScalarInfo.isGraphqlSpecifiedScalar(scalarTypeDefinition.getName())) {
                return;
            }
            if (buildCtx.hasInputType((TypeDefinition)scalarTypeDefinition) == null && buildCtx.hasOutputType((TypeDefinition)scalarTypeDefinition) == null) {
                additionalTypes.add(this.buildScalar(buildCtx, (ScalarTypeDefinition)scalarTypeDefinition));
            }
        });
        return additionalTypes;
    }

    Set<GraphQLDirective> buildAdditionalDirectives(BuildContext buildCtx) {
        LinkedHashSet<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        for (DirectiveDefinition directiveDefinition : typeRegistry.getDirectiveDefinitions().values()) {
            Function<Type, GraphQLInputType> inputTypeFactory = inputType -> this.buildInputType(buildCtx, (Type)inputType);
            GraphQLDirective directive = this.buildDirectiveFromDefinition(directiveDefinition, inputTypeFactory);
            buildCtx.addDirectiveDefinition(directive);
            additionalDirectives.add(directive);
        }
        return additionalDirectives;
    }

    void addDirectivesIncludedByDefault(TypeDefinitionRegistry typeRegistry) {
        typeRegistry.add(DEPRECATED_DIRECTIVE_DEFINITION);
        typeRegistry.add(SPECIFIED_BY_DIRECTIVE_DEFINITION);
    }

    private Optional<OperationTypeDefinition> getOperationNamed(String name, Map<String, OperationTypeDefinition> operationTypeDefs) {
        return Optional.ofNullable(operationTypeDefs.get(name));
    }

    private DataFetcher<?> dataFetcherOfLastResort(FieldWiringEnvironment environment) {
        String fieldName = environment.getFieldDefinition().getName();
        return new PropertyDataFetcher(fieldName);
    }

    private List<Directive> directivesOf(List<? extends TypeDefinition> typeDefinitions) {
        return typeDefinitions.stream().map(DirectivesContainer::getDirectives).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Deque<String> typeStack = new ArrayDeque<String>();
        private final Map<String, GraphQLOutputType> outputGTypes = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new LinkedHashMap<String, GraphQLInputType>();
        private final Map<String, Object> directiveBehaviourContext = new LinkedHashMap<String, Object>();
        private final Set<GraphQLDirective> directives = new LinkedHashSet<GraphQLDirective>();
        private final GraphQLCodeRegistry.Builder codeRegistry;
        public final Map<String, OperationTypeDefinition> operationTypeDefs;

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
            this.codeRegistry = GraphQLCodeRegistry.newCodeRegistry(wiring.getCodeRegistry());
            this.operationTypeDefs = operationTypeDefinitions;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition getTypeDefinition(Type type) {
            Optional<TypeDefinition> optionalTypeDefinition = this.typeRegistry.getType(type);
            return optionalTypeDefinition.orElseThrow(() -> new AssertException(String.format(" type definition for type '%s' not found", type)));
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.typeStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.typeStack.push(typeInfo.getName());
        }

        void pop() {
            this.typeStack.pop();
        }

        GraphQLOutputType hasOutputType(TypeDefinition typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void putOutputType(GraphQLNamedOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void putInputType(GraphQLNamedInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }

        GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.wiring.getComparatorRegistry();
        }

        public GraphQLCodeRegistry.Builder getCodeRegistry() {
            return this.codeRegistry;
        }

        public void addDirectiveDefinition(GraphQLDirective directive) {
            this.directives.add(directive);
        }

        public void addDirectives(Set<GraphQLDirective> directives) {
            this.directives.addAll(directives);
        }

        public Set<GraphQLDirective> getDirectives() {
            return this.directives;
        }
    }
}

