/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.introspection.Introspection;
import graphql.language.TypeName;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.schema.validation.SchemaValidationRule;
import graphql.util.FpKit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class TypeAndFieldRule
implements SchemaValidationRule {
    private Map<String, GraphQLNamedType> schemaTypeHolder;

    @Override
    public void check(GraphQLSchema graphQLSchema, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLNamedType> allTypesAsList = graphQLSchema.getAllTypesAsList();
        List<GraphQLNamedType> filteredType = this.filterBuiltInTypes(allTypesAsList);
        this.schemaTypeHolder = graphQLSchema.getTypeMap();
        this.checkTypes(filteredType, validationErrorCollector);
    }

    private void checkTypes(List<GraphQLNamedType> customizedType, SchemaValidationErrorCollector errorCollector) {
        if (customizedType == null || customizedType.isEmpty()) {
            return;
        }
        for (GraphQLType graphQLType : customizedType) {
            this.checkType(graphQLType, errorCollector);
        }
    }

    private void checkType(GraphQLType type, SchemaValidationErrorCollector errorCollector) {
        if (type instanceof GraphQLObjectType || type instanceof GraphQLInterfaceType) {
            this.validateContainsField((GraphQLFieldsContainer)type, errorCollector);
        } else if (type instanceof GraphQLUnionType) {
            this.validateUnion((GraphQLUnionType)type, errorCollector);
        } else if (type instanceof GraphQLEnumType) {
            this.validateEnum((GraphQLEnumType)type, errorCollector);
        } else if (type instanceof GraphQLInputObjectType) {
            this.validateInputObject((GraphQLInputObjectType)type, errorCollector);
        } else if (type instanceof GraphQLScalarType) {
            this.validateScalar((GraphQLScalarType)type, errorCollector);
        }
    }

    private void validateContainsField(GraphQLFieldsContainer type, SchemaValidationErrorCollector errorCollector) {
        this.assertTypeName(type.getName(), errorCollector);
        List<GraphQLFieldDefinition> fieldDefinitions = type.getFieldDefinitions();
        if (fieldDefinitions == null || fieldDefinitions.size() == 0) {
            SchemaValidationError validationError = new SchemaValidationError(SchemaValidationErrorType.ImplementingTypeLackOfFieldError, String.format("\"%s\" must define one or more fields.", type.getName()));
            errorCollector.addError(validationError);
            return;
        }
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            this.validateFieldDefinition(type.getName(), fieldDefinition, errorCollector);
        }
    }

    private void validateInputObject(GraphQLInputObjectType type, SchemaValidationErrorCollector errorCollector) {
        this.assertTypeName(type.getName(), errorCollector);
        List<GraphQLInputObjectField> inputObjectFields = type.getFields();
        if (inputObjectFields == null || inputObjectFields.size() == 0) {
            SchemaValidationError validationError = new SchemaValidationError(SchemaValidationErrorType.InputObjectTypeLackOfFieldError, String.format("\"%s\" must define one or more fields.", type.getName()));
            errorCollector.addError(validationError);
            return;
        }
        for (GraphQLInputObjectField inputObjectField : inputObjectFields) {
            this.validateInputFieldDefinition(inputObjectField.getName(), inputObjectField, errorCollector);
        }
    }

    private void validateUnion(GraphQLUnionType type, SchemaValidationErrorCollector errorCollector) {
        this.assertTypeName(type.getName(), errorCollector);
        List<GraphQLNamedOutputType> memberTypes = type.getTypes();
        if (memberTypes == null || memberTypes.size() == 0) {
            SchemaValidationError validationError = new SchemaValidationError(SchemaValidationErrorType.UnionTypeLackOfTypeError, String.format("Union type \"%s\" must include one or more unique member types.", type.getName()));
            errorCollector.addError(validationError);
        }
        HashSet<String> typeNames = new HashSet<String>();
        for (GraphQLNamedOutputType memberType : memberTypes) {
            SchemaValidationError validationError;
            String typeName = memberType.getName();
            GraphQLNamedType graphQLNamedType = this.schemaTypeHolder.get(typeName);
            if (!(graphQLNamedType instanceof GraphQLObjectType)) {
                validationError = new SchemaValidationError(SchemaValidationErrorType.InvalidUnionMemberTypeError, String.format("The member types of a Union type must all be Object base types. member type \"%s\" in Union \"%s\" is invalid.", ((TypeName)((Object)memberType)).getName(), type.getName()));
                errorCollector.addError(validationError);
            }
            if (typeNames.contains(typeName)) {
                validationError = new SchemaValidationError(SchemaValidationErrorType.RepetitiveElementError, String.format("The member types of a Union type must be unique. member type \"%s\" in Union \"%s\" is not unique.", ((TypeName)((Object)memberType)).getName(), type.getName()));
                errorCollector.addError(validationError);
            }
            typeNames.add(typeName);
        }
    }

    private void validateScalar(GraphQLScalarType type, SchemaValidationErrorCollector errorCollector) {
        this.assertTypeName(type.getName(), errorCollector);
    }

    private void validateEnum(GraphQLEnumType type, SchemaValidationErrorCollector errorCollector) {
        this.assertTypeName(type.getName(), errorCollector);
        List<GraphQLEnumValueDefinition> enumValueDefinitions = type.getValues();
        if (enumValueDefinitions == null || enumValueDefinitions.size() == 0) {
            SchemaValidationError validationError = new SchemaValidationError(SchemaValidationErrorType.EnumLackOfValueError, String.format("Enum type \"%s\" must define one or more enum values.", type.getName()));
            errorCollector.addError(validationError);
        } else {
            for (GraphQLEnumValueDefinition enumValueDefinition : enumValueDefinitions) {
                this.assertEnumValueDefinitionName(type.getName(), enumValueDefinition.getName(), errorCollector);
            }
        }
    }

    private void validateFieldDefinition(String typeName, GraphQLFieldDefinition fieldDefinition, SchemaValidationErrorCollector errorCollector) {
        this.assertFieldName(typeName, fieldDefinition.getName(), errorCollector);
        this.assertNonNullType(fieldDefinition.getType(), errorCollector);
        List<GraphQLArgument> fieldDefinitionArguments = fieldDefinition.getArguments();
        if (fieldDefinitionArguments != null || fieldDefinitionArguments.size() != 0) {
            for (GraphQLArgument fieldDefinitionArgument : fieldDefinitionArguments) {
                this.validateFieldDefinitionArgument(typeName, fieldDefinition.getName(), fieldDefinitionArgument, errorCollector);
            }
        }
    }

    private void validateInputFieldDefinition(String typeName, GraphQLInputObjectField inputObjectField, SchemaValidationErrorCollector errorCollector) {
        this.assertFieldName(typeName, inputObjectField.getName(), errorCollector);
        this.assertNonNullType(inputObjectField.getType(), errorCollector);
    }

    private void validateFieldDefinitionArgument(String typeName, String fieldName, GraphQLArgument argument, SchemaValidationErrorCollector errorCollector) {
        this.assertArgumentName(typeName, fieldName, argument.getName(), errorCollector);
        this.assertNonNullType(argument.getType(), errorCollector);
    }

    private void assertTypeName(String typeName, SchemaValidationErrorCollector validationErrorCollector) {
        if (typeName.length() >= 2 && typeName.startsWith("__")) {
            SchemaValidationError schemaValidationError = new SchemaValidationError(SchemaValidationErrorType.InvalidCustomizedNameError, String.format("\"%s\" must not begin with \"__\", which is reserved by GraphQL introspection.", typeName));
            validationErrorCollector.addError(schemaValidationError);
        }
    }

    private void assertFieldName(String typeName, String fieldName, SchemaValidationErrorCollector errorCollector) {
        if (fieldName.length() >= 2 && fieldName.startsWith("__")) {
            SchemaValidationError schemaValidationError = new SchemaValidationError(SchemaValidationErrorType.InvalidCustomizedNameError, String.format("\"%s\" in \"%s\" must not begin with \"__\", which is reserved by GraphQL introspection.", fieldName, typeName));
            errorCollector.addError(schemaValidationError);
        }
    }

    private void assertArgumentName(String typeName, String fieldName, String argumentName, SchemaValidationErrorCollector errorCollector) {
        if (argumentName.length() >= 2 && argumentName.startsWith("__")) {
            SchemaValidationError schemaValidationError = new SchemaValidationError(SchemaValidationErrorType.InvalidCustomizedNameError, String.format("Argument name \"%s\" in \"%s-%s\" must not begin with \"__\", which is reserved by GraphQL introspection.", argumentName, typeName, fieldName));
            errorCollector.addError(schemaValidationError);
        }
    }

    private void assertEnumValueDefinitionName(String typeName, String enumValueDefinitionName, SchemaValidationErrorCollector errorCollector) {
        if (enumValueDefinitionName.length() >= 2 && enumValueDefinitionName.startsWith("__")) {
            SchemaValidationError schemaValidationError = new SchemaValidationError(SchemaValidationErrorType.InvalidCustomizedNameError, String.format("EnumValueDefinition \"%s\" in  \"%s\"  must not begin with \"__\", which is reserved by GraphQL introspection.", enumValueDefinitionName, typeName));
            errorCollector.addError(schemaValidationError);
        }
    }

    private void assertNonNullType(GraphQLType type, SchemaValidationErrorCollector errorCollector) {
        if (type instanceof GraphQLNonNull && ((GraphQLNonNull)type).getWrappedType() instanceof GraphQLNonNull) {
            SchemaValidationError schemaValidationError = new SchemaValidationError(SchemaValidationErrorType.NonNullWrapNonNullError, String.format("Non\u2010Null type must not wrap another Non\u2010Null type: \"%s\" is invalid.", GraphQLTypeUtil.simplePrint(type)));
            errorCollector.addError(schemaValidationError);
        }
    }

    private List<GraphQLNamedType> filterBuiltInTypes(List<GraphQLNamedType> graphQLNamedTypes) {
        if (graphQLNamedTypes == null || graphQLNamedTypes.isEmpty()) {
            return Collections.emptyList();
        }
        Predicate<GraphQLNamedType> filterFunction = namedType -> {
            if (Introspection.isIntrospectionTypes(namedType)) {
                return false;
            }
            return !(namedType instanceof GraphQLScalarType) || !ScalarInfo.isGraphqlSpecifiedScalar((GraphQLScalarType)namedType);
        };
        return FpKit.filterList(graphQLNamedTypes, filterFunction);
    }

    @Override
    public void check(GraphQLFieldDefinition fieldDef, SchemaValidationErrorCollector validationErrorCollector) {
    }

    @Override
    public void check(GraphQLType type, SchemaValidationErrorCollector validationErrorCollector) {
    }
}

