/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.SystemClock;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class SdkMeterProviderBuilder {
    private Clock clock = SystemClock.getInstance();
    private Resource resource = Resource.getDefault();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(@Nonnull Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(@Nonnull Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMetricsProvider.set(meterProvider);
        return meterProvider;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.clock, this.resource);
    }
}

