/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AbstractDriverOptions;

public class ChromiumOptions<T extends ChromiumOptions<?>>
extends AbstractDriverOptions<ChromiumOptions<?>> {
    private String binary;
    private final List<String> args = new ArrayList<String>();
    private final List<File> extensionFiles = new ArrayList<File>();
    private final List<String> extensions = new ArrayList<String>();
    private final Map<String, Object> experimentalOptions = new HashMap<String, Object>();
    private final String CAPABILITY;

    public ChromiumOptions(String capabilityType, String browserType, String capability) {
        this.CAPABILITY = capability;
        this.setCapability(capabilityType, browserType);
    }

    public T setBinary(File path) {
        this.binary = Require.nonNull("Path to the chrome executable", path).getPath();
        return (T)this;
    }

    public T setBinary(String path) {
        this.binary = Require.nonNull("Path to the chrome executable", path);
        return (T)this;
    }

    public T addArguments(String ... arguments) {
        this.addArguments(Arrays.asList(arguments));
        return (T)this;
    }

    public T addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return (T)this;
    }

    public T addExtensions(File ... paths) {
        this.addExtensions(Arrays.asList(paths));
        return (T)this;
    }

    public T addExtensions(List<File> paths) {
        paths.forEach(path -> Require.argument("Extension", path).isFile());
        this.extensionFiles.addAll(paths);
        return (T)this;
    }

    public T addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(Arrays.asList(encoded));
        return (T)this;
    }

    public T addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Require.nonNull("Encoded extension", extension);
        }
        this.extensions.addAll(encoded);
        return (T)this;
    }

    public T setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(Require.nonNull("Option name", name), value);
        return (T)this;
    }

    public T setHeadless(boolean headless) {
        this.args.remove("--headless");
        if (headless) {
            this.args.add("--headless");
        }
        return (T)this;
    }

    @Override
    protected int amendHashCode() {
        return Objects.hash(this.args, this.binary, this.experimentalOptions, this.extensionFiles, this.extensions);
    }

    @Override
    public Map<String, Object> asMap() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", Collections.unmodifiableList(new ArrayList<String>(this.args)));
        options.put("extensions", Collections.unmodifiableList(Stream.concat(this.extensionFiles.stream().map(file -> {
            try {
                return Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                throw new SessionNotCreatedException(e.getMessage(), e);
            }
        }), this.extensions.stream()).collect(Collectors.toList())));
        toReturn.put(this.CAPABILITY, Collections.unmodifiableMap(options));
        return Collections.unmodifiableMap(toReturn);
    }

    protected void mergeInPlace(Capabilities capabilities) {
        Require.nonNull("Capabilities to merge", capabilities);
        capabilities.getCapabilityNames().forEach(name -> this.setCapability((String)name, capabilities.getCapability((String)name)));
        if (capabilities instanceof ChromiumOptions) {
            ChromiumOptions options = (ChromiumOptions)capabilities;
            for (String arg : options.args) {
                if (this.args.contains(arg)) continue;
                this.addArguments(arg);
            }
            this.addExtensions(options.extensionFiles);
            this.addEncodedExtensions(options.extensions);
            if (options.binary != null) {
                this.setBinary(options.binary);
            }
            options.experimentalOptions.forEach(this::setExperimentalOption);
        }
    }
}

