/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.concurrent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.internal.Require;

public class Regularly {
    private final ScheduledExecutorService executor;
    private final List<RetryingRunnable> scheduledRunnables = new ArrayList<RetryingRunnable>();

    public Regularly(String name) {
        Require.nonNull("Name", name);
        this.executor = Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r, name);
            thread.setDaemon(true);
            return thread;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable task, Duration successPeriod, Duration retryPeriod) {
        Require.nonNull("Task to schedule", task);
        Require.nonNull("Success period", successPeriod);
        Require.nonNull("Retry period", retryPeriod);
        RetryingRunnable runnable = new RetryingRunnable(task, successPeriod.toMillis(), retryPeriod.toMillis());
        List<RetryingRunnable> list = this.scheduledRunnables;
        synchronized (list) {
            this.scheduledRunnables.add(runnable);
        }
        this.executor.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable runnable) {
        List<RetryingRunnable> list = this.scheduledRunnables;
        synchronized (list) {
            Iterator<RetryingRunnable> iterator = this.scheduledRunnables.iterator();
            while (iterator.hasNext()) {
                RetryingRunnable compareWith = iterator.next();
                if (!compareWith.equals(runnable)) continue;
                iterator.remove();
                compareWith.stop();
            }
        }
    }

    private class RetryingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final long successPeriod;
        private final long retryPeriod;
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public RetryingRunnable(Runnable delegate, long successPeriod, long retryPeriod) {
            this.delegate = delegate;
            this.successPeriod = successPeriod;
            this.retryPeriod = retryPeriod;
        }

        @Override
        public void run() {
            if (this.stop.get()) {
                return;
            }
            try {
                this.delegate.run();
                Regularly.this.executor.schedule(this, this.successPeriod, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Regularly.this.executor.schedule(this, this.retryPeriod, TimeUnit.MILLISECONDS);
            }
        }

        public void stop() {
            this.stop.set(true);
        }
    }
}

