/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.idealized;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.OpaqueKey;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;

public abstract class Network<AUTHREQUIRED, REQUESTPAUSED> {
    private final Map<Predicate<URI>, Supplier<Credentials>> authHandlers = new LinkedHashMap<Predicate<URI>, Supplier<Credentials>>();
    private final Map<Predicate<HttpRequest>, Function<HttpRequest, HttpResponse>> uriHandlers = new LinkedHashMap<Predicate<HttpRequest>, Function<HttpRequest, HttpResponse>>();
    protected final DevTools devTools;
    private boolean interceptingTraffic = false;

    public Network(DevTools devtools) {
        this.devTools = Require.nonNull("DevTools", devtools);
    }

    public void disable() {
        this.devTools.send(this.disableFetch());
        this.devTools.send(this.enableNetworkCaching());
        this.authHandlers.clear();
        this.uriHandlers.clear();
        this.interceptingTraffic = false;
    }

    public void setUserAgent(String userAgent) {
        this.devTools.send(this.setUserAgentOverride(new UserAgent(userAgent)));
    }

    public void setUserAgent(UserAgent userAgent) {
        this.devTools.send(this.setUserAgentOverride(userAgent));
    }

    public void addAuthHandler(Predicate<URI> whenThisMatches, Supplier<Credentials> useTheseCredentials) {
        Require.nonNull("URI predicate", whenThisMatches);
        Require.nonNull("Credentials", useTheseCredentials);
        this.authHandlers.put(whenThisMatches, useTheseCredentials);
        this.prepareToInterceptTraffic();
    }

    public OpaqueKey addRequestHandler(Routable routable) {
        Require.nonNull("Routable", routable);
        return this.addRequestHandler(routable::matches, routable::execute);
    }

    public OpaqueKey addRequestHandler(Predicate<HttpRequest> whenThisMatches, Function<HttpRequest, HttpResponse> returnThis) {
        Require.nonNull("Request predicate", whenThisMatches);
        Require.nonNull("Handler", returnThis);
        this.uriHandlers.put(whenThisMatches, returnThis);
        this.prepareToInterceptTraffic();
        return new OpaqueKey(whenThisMatches);
    }

    public void removeRequestHandler(OpaqueKey key) {
        Require.nonNull("Key", key);
        this.uriHandlers.remove(key.getValue());
    }

    private void prepareToInterceptTraffic() {
        if (this.interceptingTraffic) {
            return;
        }
        this.devTools.send(this.disableNetworkCaching());
        this.devTools.addListener(this.authRequiredEvent(), authRequired -> {
            String origin = this.getUriFrom(authRequired);
            try {
                URI uri = new URI(origin);
                Optional<Credentials> authCredentials = this.getAuthCredentials(uri);
                if (authCredentials.isPresent()) {
                    Credentials credentials = authCredentials.get();
                    if (!(credentials instanceof UsernameAndPassword)) {
                        throw new DevToolsException("DevTools can only support username and password authentication");
                    }
                    UsernameAndPassword uap = (UsernameAndPassword)credentials;
                    this.devTools.send(this.continueWithAuth(authRequired, uap));
                    return;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.devTools.send(this.cancelAuth(authRequired));
        });
        this.devTools.addListener(this.requestPausedEvent(), pausedRequest -> {
            Optional<HttpRequest> req = this.createHttpRequest(pausedRequest);
            if (!req.isPresent()) {
                this.devTools.send(this.continueWithoutModification(pausedRequest));
                return;
            }
            Optional<HttpResponse> maybeRes = this.getHttpResponse(req.get());
            if (!maybeRes.isPresent()) {
                this.devTools.send(this.continueWithoutModification(pausedRequest));
                return;
            }
            HttpResponse response = maybeRes.get();
            if ("Continue".equals(response.getHeader("Selenium-Interceptor"))) {
                this.devTools.send(this.continueWithoutModification(pausedRequest));
                return;
            }
            this.devTools.send(this.createResponse(pausedRequest, response));
        });
        this.devTools.send(this.enableFetchForAllPatterns());
        this.interceptingTraffic = true;
    }

    protected Optional<Credentials> getAuthCredentials(URI uri) {
        Require.nonNull("URI", uri);
        return this.authHandlers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(uri)).map(Map.Entry::getValue).map(Supplier::get).findFirst();
    }

    protected Optional<HttpResponse> getHttpResponse(HttpRequest forRequest) {
        Require.nonNull("Request", forRequest);
        return this.uriHandlers.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(forRequest)).map(Map.Entry::getValue).map(func -> (HttpResponse)func.apply(forRequest)).findFirst();
    }

    protected HttpMethod convertFromCdpHttpMethod(String method) {
        Require.nonNull("HTTP Method", method);
        try {
            return HttpMethod.valueOf(method.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return HttpMethod.GET;
        }
    }

    protected HttpRequest createHttpRequest(String cdpMethod, String url, Map<String, Object> headers, Optional<String> postData) {
        HttpRequest req = new HttpRequest(this.convertFromCdpHttpMethod(cdpMethod), url);
        headers.forEach((key, value) -> req.addHeader((String)key, String.valueOf(value)));
        postData.ifPresent(data -> req.setContent((Supplier)Contents.utf8String(data)));
        return req;
    }

    protected abstract Command<Void> setUserAgentOverride(UserAgent var1);

    protected abstract Command<Void> enableNetworkCaching();

    protected abstract Command<Void> disableNetworkCaching();

    protected abstract Command<Void> enableFetchForAllPatterns();

    protected abstract Command<Void> disableFetch();

    protected abstract Event<AUTHREQUIRED> authRequiredEvent();

    protected abstract String getUriFrom(AUTHREQUIRED var1);

    protected abstract Command<Void> continueWithAuth(AUTHREQUIRED var1, UsernameAndPassword var2);

    protected abstract Command<Void> cancelAuth(AUTHREQUIRED var1);

    protected abstract Event<REQUESTPAUSED> requestPausedEvent();

    protected abstract Optional<HttpRequest> createHttpRequest(REQUESTPAUSED var1);

    protected abstract Command<Void> continueWithoutModification(REQUESTPAUSED var1);

    protected abstract Command<Void> createResponse(REQUESTPAUSED var1, HttpResponse var2);

    public static class UserAgent {
        private final String userAgent;
        private final Optional<String> acceptLanguage;
        private final Optional<String> platform;

        public UserAgent(String userAgent) {
            this(userAgent, Optional.empty(), Optional.empty());
        }

        private UserAgent(String userAgent, Optional<String> acceptLanguage, Optional<String> platform) {
            this.userAgent = userAgent;
            this.acceptLanguage = acceptLanguage;
            this.platform = platform;
        }

        public String userAgent() {
            return this.userAgent;
        }

        public UserAgent acceptLanguage(String acceptLanguage) {
            return new UserAgent(this.userAgent, Optional.of(acceptLanguage), this.platform);
        }

        public Optional<String> acceptLanguage() {
            return this.acceptLanguage;
        }

        public UserAgent platform(String platform) {
            return new UserAgent(this.userAgent, this.acceptLanguage, Optional.of(platform));
        }

        public Optional<String> platform() {
            return this.platform;
        }
    }
}

