/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Optional;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.v88.fetch.Fetch;
import org.openqa.selenium.devtools.v88.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v88.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v88.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v88.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v88.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v88.network.Network;
import org.openqa.selenium.devtools.v88.network.model.Request;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class V88Network
extends org.openqa.selenium.devtools.idealized.Network<AuthRequired, RequestPaused> {
    public V88Network(DevTools devTools) {
        super(devTools);
    }

    @Override
    protected Command<Void> setUserAgentOverride(Network.UserAgent userAgent) {
        return Network.setUserAgentOverride(userAgent.userAgent(), userAgent.acceptLanguage(), userAgent.platform(), Optional.empty());
    }

    @Override
    protected Command<Void> enableNetworkCaching() {
        return Network.setCacheDisabled(false);
    }

    @Override
    protected Command<Void> disableNetworkCaching() {
        return Network.setCacheDisabled(true);
    }

    @Override
    protected Command<Void> enableFetchForAllPatterns() {
        return Fetch.enable(Optional.of(ImmutableList.of(new RequestPattern(Optional.of("*"), Optional.empty(), Optional.empty()))), Optional.of(true));
    }

    @Override
    protected Command<Void> disableFetch() {
        return Fetch.disable();
    }

    @Override
    protected Event<AuthRequired> authRequiredEvent() {
        return Fetch.authRequired();
    }

    @Override
    protected String getUriFrom(AuthRequired authRequired) {
        return authRequired.getAuthChallenge().getOrigin();
    }

    @Override
    protected Command<Void> continueWithAuth(AuthRequired authRequired, UsernameAndPassword credentials) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.PROVIDECREDENTIALS, Optional.of(credentials.username()), Optional.ofNullable(credentials.password())));
    }

    @Override
    protected Command<Void> cancelAuth(AuthRequired authRequired) {
        return Fetch.continueWithAuth(authRequired.getRequestId(), new AuthChallengeResponse(AuthChallengeResponse.Response.CANCELAUTH, Optional.empty(), Optional.empty()));
    }

    @Override
    protected Event<RequestPaused> requestPausedEvent() {
        return Fetch.requestPaused();
    }

    @Override
    protected Optional<HttpRequest> createHttpRequest(RequestPaused pausedRequest) {
        if (pausedRequest.getResponseErrorReason().isPresent() || pausedRequest.getResponseStatusCode().isPresent()) {
            return Optional.empty();
        }
        Request cdpRequest = pausedRequest.getRequest();
        return Optional.of(this.createHttpRequest(cdpRequest.getMethod(), cdpRequest.getUrl(), cdpRequest.getHeaders(), cdpRequest.getPostData()));
    }

    @Override
    protected Command<Void> continueWithoutModification(RequestPaused pausedRequest) {
        return Fetch.continueRequest(pausedRequest.getRequestId(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    protected Command<Void> createResponse(RequestPaused pausedRequest, HttpResponse response) {
        ArrayList headers = new ArrayList();
        response.getHeaderNames().forEach(name -> response.getHeaders((String)name).forEach(value -> headers.add(new HeaderEntry((String)name, (String)value))));
        byte[] bytes = Contents.bytes(response.getContent());
        String body = bytes.length > 0 ? Base64.getEncoder().encodeToString(bytes) : null;
        return Fetch.fulfillRequest(pausedRequest.getRequestId(), response.getStatus(), Optional.of(headers), Optional.empty(), Optional.ofNullable(body), Optional.empty());
    }
}

