/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.accessibility;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v88.accessibility.model.AXNode;
import org.openqa.selenium.devtools.v88.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v88.dom.model.NodeId;
import org.openqa.selenium.devtools.v88.runtime.model.RemoteObjectId;

@Beta
public class Accessibility {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Accessibility.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Accessibility.enable", params.build());
    }

    @Beta
    public static Command<List<AXNode>> getPartialAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Boolean> fetchRelatives) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command<List<AXNode>>("Accessibility.getPartialAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> getFullAXTree() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<AXNode>>("Accessibility.getFullAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }

    @Beta
    public static Command<List<AXNode>> queryAXTree(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> accessibleName, Optional<String> role) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        accessibleName.ifPresent(p -> params.put("accessibleName", p));
        role.ifPresent(p -> params.put("role", p));
        return new Command<List<AXNode>>("Accessibility.queryAXTree", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<AXNode>>(){}.getType()));
    }
}

