/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.audits.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v88.audits.model.AffectedCookie;
import org.openqa.selenium.devtools.v88.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v88.audits.model.SameSiteCookieExclusionReason;
import org.openqa.selenium.devtools.v88.audits.model.SameSiteCookieOperation;
import org.openqa.selenium.devtools.v88.audits.model.SameSiteCookieWarningReason;
import org.openqa.selenium.json.JsonInput;

public class SameSiteCookieIssueDetails {
    private final AffectedCookie cookie;
    private final List<SameSiteCookieWarningReason> cookieWarningReasons;
    private final List<SameSiteCookieExclusionReason> cookieExclusionReasons;
    private final SameSiteCookieOperation operation;
    private final Optional<String> siteForCookies;
    private final Optional<String> cookieUrl;
    private final Optional<AffectedRequest> request;

    public SameSiteCookieIssueDetails(AffectedCookie cookie, List<SameSiteCookieWarningReason> cookieWarningReasons, List<SameSiteCookieExclusionReason> cookieExclusionReasons, SameSiteCookieOperation operation, Optional<String> siteForCookies, Optional<String> cookieUrl, Optional<AffectedRequest> request) {
        this.cookie = Objects.requireNonNull(cookie, "cookie is required");
        this.cookieWarningReasons = Objects.requireNonNull(cookieWarningReasons, "cookieWarningReasons is required");
        this.cookieExclusionReasons = Objects.requireNonNull(cookieExclusionReasons, "cookieExclusionReasons is required");
        this.operation = Objects.requireNonNull(operation, "operation is required");
        this.siteForCookies = siteForCookies;
        this.cookieUrl = cookieUrl;
        this.request = request;
    }

    public AffectedCookie getCookie() {
        return this.cookie;
    }

    public List<SameSiteCookieWarningReason> getCookieWarningReasons() {
        return this.cookieWarningReasons;
    }

    public List<SameSiteCookieExclusionReason> getCookieExclusionReasons() {
        return this.cookieExclusionReasons;
    }

    public SameSiteCookieOperation getOperation() {
        return this.operation;
    }

    public Optional<String> getSiteForCookies() {
        return this.siteForCookies;
    }

    public Optional<String> getCookieUrl() {
        return this.cookieUrl;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    private static SameSiteCookieIssueDetails fromJson(JsonInput input) {
        AffectedCookie cookie = null;
        List cookieWarningReasons = null;
        List cookieExclusionReasons = null;
        SameSiteCookieOperation operation = null;
        Optional<String> siteForCookies = Optional.empty();
        Optional<String> cookieUrl = Optional.empty();
        Optional<AffectedRequest> request = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "cookie": {
                    cookie = (AffectedCookie)input.read((Type)((Object)AffectedCookie.class));
                    continue block18;
                }
                case "cookieWarningReasons": {
                    cookieWarningReasons = (List)input.read(new TypeToken<List<SameSiteCookieWarningReason>>(){}.getType());
                    continue block18;
                }
                case "cookieExclusionReasons": {
                    cookieExclusionReasons = (List)input.read(new TypeToken<List<SameSiteCookieExclusionReason>>(){}.getType());
                    continue block18;
                }
                case "operation": {
                    operation = (SameSiteCookieOperation)((Object)input.read((Type)((Object)SameSiteCookieOperation.class)));
                    continue block18;
                }
                case "siteForCookies": {
                    siteForCookies = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "cookieUrl": {
                    cookieUrl = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read((Type)((Object)AffectedRequest.class)));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SameSiteCookieIssueDetails(cookie, cookieWarningReasons, cookieExclusionReasons, operation, siteForCookies, cookieUrl, request);
    }
}

