/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.emulation;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v88.dom.model.RGBA;
import org.openqa.selenium.devtools.v88.emulation.model.DisabledImageType;
import org.openqa.selenium.devtools.v88.emulation.model.DisplayFeature;
import org.openqa.selenium.devtools.v88.emulation.model.MediaFeature;
import org.openqa.selenium.devtools.v88.emulation.model.ScreenOrientation;
import org.openqa.selenium.devtools.v88.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v88.emulation.model.VirtualTimePolicy;
import org.openqa.selenium.devtools.v88.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v88.page.model.Viewport;
import org.openqa.selenium.json.JsonInput;

public class Emulation {
    public static Command<Boolean> canEmulate() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Boolean>("Emulation.canEmulate", params.build(), ConverterFunctions.map("result", Boolean.class));
    }

    public static Command<Void> clearDeviceMetricsOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Emulation.clearDeviceMetricsOverride", params.build());
    }

    public static Command<Void> clearGeolocationOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Emulation.clearGeolocationOverride", params.build());
    }

    @Beta
    public static Command<Void> resetPageScaleFactor() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Emulation.resetPageScaleFactor", params.build());
    }

    @Beta
    public static Command<Void> setFocusEmulationEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        return new Command<Void>("Emulation.setFocusEmulationEnabled", params.build());
    }

    @Beta
    public static Command<Void> setCPUThrottlingRate(Number rate) {
        Objects.requireNonNull(rate, "rate is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("rate", rate);
        return new Command<Void>("Emulation.setCPUThrottlingRate", params.build());
    }

    public static Command<Void> setDefaultBackgroundColorOverride(Optional<RGBA> color) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        color.ifPresent(p -> params.put("color", p));
        return new Command<Void>("Emulation.setDefaultBackgroundColorOverride", params.build());
    }

    public static Command<Void> setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<Number> scale, Optional<Integer> screenWidth, Optional<Integer> screenHeight, Optional<Integer> positionX, Optional<Integer> positionY, Optional<Boolean> dontSetVisibleSize, Optional<ScreenOrientation> screenOrientation, Optional<Viewport> viewport, Optional<DisplayFeature> displayFeature) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        Objects.requireNonNull(deviceScaleFactor, "deviceScaleFactor is required");
        Objects.requireNonNull(mobile, "mobile is required");
        ImmutableMap.Builder<String, Serializable> params = ImmutableMap.builder();
        params.put("width", width);
        params.put("height", height);
        params.put("deviceScaleFactor", deviceScaleFactor);
        params.put("mobile", mobile);
        scale.ifPresent(p -> params.put("scale", (Serializable)p));
        screenWidth.ifPresent(p -> params.put("screenWidth", (Serializable)p));
        screenHeight.ifPresent(p -> params.put("screenHeight", (Serializable)p));
        positionX.ifPresent(p -> params.put("positionX", (Serializable)p));
        positionY.ifPresent(p -> params.put("positionY", (Serializable)p));
        dontSetVisibleSize.ifPresent(p -> params.put("dontSetVisibleSize", (Serializable)p));
        screenOrientation.ifPresent(p -> params.put("screenOrientation", (Serializable)p));
        viewport.ifPresent(p -> params.put("viewport", (Serializable)p));
        displayFeature.ifPresent(p -> params.put("displayFeature", (Serializable)p));
        return new Command<Void>("Emulation.setDeviceMetricsOverride", params.build());
    }

    @Beta
    public static Command<Void> setScrollbarsHidden(Boolean hidden) {
        Objects.requireNonNull(hidden, "hidden is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("hidden", hidden);
        return new Command<Void>("Emulation.setScrollbarsHidden", params.build());
    }

    @Beta
    public static Command<Void> setDocumentCookieDisabled(Boolean disabled) {
        Objects.requireNonNull(disabled, "disabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("disabled", disabled);
        return new Command<Void>("Emulation.setDocumentCookieDisabled", params.build());
    }

    @Beta
    public static Command<Void> setEmitTouchEventsForMouse(Boolean enabled, Optional<SetEmitTouchEventsForMouseConfiguration> configuration) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        configuration.ifPresent(p -> params.put("configuration", (Boolean)p));
        return new Command<Void>("Emulation.setEmitTouchEventsForMouse", params.build());
    }

    public static Command<Void> setEmulatedMedia(Optional<String> media, Optional<List<MediaFeature>> features) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        media.ifPresent(p -> params.put("media", p));
        features.ifPresent(p -> params.put("features", p));
        return new Command<Void>("Emulation.setEmulatedMedia", params.build());
    }

    @Beta
    public static Command<Void> setEmulatedVisionDeficiency(SetEmulatedVisionDeficiencyType type) {
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder<String, SetEmulatedVisionDeficiencyType> params = ImmutableMap.builder();
        params.put("type", type);
        return new Command<Void>("Emulation.setEmulatedVisionDeficiency", params.build());
    }

    public static Command<Void> setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        latitude.ifPresent(p -> params.put("latitude", p));
        longitude.ifPresent(p -> params.put("longitude", p));
        accuracy.ifPresent(p -> params.put("accuracy", p));
        return new Command<Void>("Emulation.setGeolocationOverride", params.build());
    }

    @Beta
    public static Command<Void> setIdleOverride(Boolean isUserActive, Boolean isScreenUnlocked) {
        Objects.requireNonNull(isUserActive, "isUserActive is required");
        Objects.requireNonNull(isScreenUnlocked, "isScreenUnlocked is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("isUserActive", isUserActive);
        params.put("isScreenUnlocked", isScreenUnlocked);
        return new Command<Void>("Emulation.setIdleOverride", params.build());
    }

    @Beta
    public static Command<Void> clearIdleOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Emulation.clearIdleOverride", params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setNavigatorOverrides(String platform) {
        Objects.requireNonNull(platform, "platform is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("platform", platform);
        return new Command<Void>("Emulation.setNavigatorOverrides", params.build());
    }

    @Beta
    public static Command<Void> setPageScaleFactor(Number pageScaleFactor) {
        Objects.requireNonNull(pageScaleFactor, "pageScaleFactor is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("pageScaleFactor", pageScaleFactor);
        return new Command<Void>("Emulation.setPageScaleFactor", params.build());
    }

    public static Command<Void> setScriptExecutionDisabled(Boolean value) {
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("value", value);
        return new Command<Void>("Emulation.setScriptExecutionDisabled", params.build());
    }

    public static Command<Void> setTouchEmulationEnabled(Boolean enabled, Optional<Integer> maxTouchPoints) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        maxTouchPoints.ifPresent(p -> params.put("maxTouchPoints", (Boolean)p));
        return new Command<Void>("Emulation.setTouchEmulationEnabled", params.build());
    }

    @Beta
    public static Command<Number> setVirtualTimePolicy(VirtualTimePolicy policy, Optional<Number> budget, Optional<Integer> maxVirtualTimeTaskStarvationCount, Optional<Boolean> waitForNavigation, Optional<TimeSinceEpoch> initialVirtualTime) {
        Objects.requireNonNull(policy, "policy is required");
        ImmutableMap.Builder<String, VirtualTimePolicy> params = ImmutableMap.builder();
        params.put("policy", policy);
        budget.ifPresent(p -> params.put("budget", (VirtualTimePolicy)((Object)p)));
        maxVirtualTimeTaskStarvationCount.ifPresent(p -> params.put("maxVirtualTimeTaskStarvationCount", (VirtualTimePolicy)((Object)p)));
        waitForNavigation.ifPresent(p -> params.put("waitForNavigation", (VirtualTimePolicy)((Object)p)));
        initialVirtualTime.ifPresent(p -> params.put("initialVirtualTime", (VirtualTimePolicy)((Object)p)));
        return new Command<Number>("Emulation.setVirtualTimePolicy", params.build(), ConverterFunctions.map("virtualTimeTicksBase", Number.class));
    }

    @Beta
    public static Command<Void> setLocaleOverride(Optional<String> locale) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        locale.ifPresent(p -> params.put("locale", p));
        return new Command<Void>("Emulation.setLocaleOverride", params.build());
    }

    @Beta
    public static Command<Void> setTimezoneOverride(String timezoneId) {
        Objects.requireNonNull(timezoneId, "timezoneId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("timezoneId", timezoneId);
        return new Command<Void>("Emulation.setTimezoneOverride", params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setVisibleSize(Integer width, Integer height) {
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("width", width);
        params.put("height", height);
        return new Command<Void>("Emulation.setVisibleSize", params.build());
    }

    @Beta
    public static Command<Void> setDisabledImageTypes(List<DisabledImageType> imageTypes) {
        Objects.requireNonNull(imageTypes, "imageTypes is required");
        ImmutableMap.Builder<String, List<DisabledImageType>> params = ImmutableMap.builder();
        params.put("imageTypes", imageTypes);
        return new Command<Void>("Emulation.setDisabledImageTypes", params.build());
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", (String)p));
        platform.ifPresent(p -> params.put("platform", (String)p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", (String)p));
        return new Command<Void>("Emulation.setUserAgentOverride", params.build());
    }

    public static Event<Void> virtualTimeBudgetExpired() {
        return new Event<Void>("Emulation.virtualTimeBudgetExpired", input -> null);
    }

    public static enum SetEmulatedVisionDeficiencyType {
        NONE("none"),
        ACHROMATOPSIA("achromatopsia"),
        BLURREDVISION("blurredVision"),
        DEUTERANOPIA("deuteranopia"),
        PROTANOPIA("protanopia"),
        TRITANOPIA("tritanopia");

        private String value;

        private SetEmulatedVisionDeficiencyType(String value) {
            this.value = value;
        }

        public static SetEmulatedVisionDeficiencyType fromString(String s2) {
            return Arrays.stream(SetEmulatedVisionDeficiencyType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetEmulatedVisionDeficiencyType "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmulatedVisionDeficiencyType fromJson(JsonInput input) {
            return SetEmulatedVisionDeficiencyType.fromString(input.nextString());
        }
    }

    public static enum SetEmitTouchEventsForMouseConfiguration {
        MOBILE("mobile"),
        DESKTOP("desktop");

        private String value;

        private SetEmitTouchEventsForMouseConfiguration(String value) {
            this.value = value;
        }

        public static SetEmitTouchEventsForMouseConfiguration fromString(String s2) {
            return Arrays.stream(SetEmitTouchEventsForMouseConfiguration.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within SetEmitTouchEventsForMouseConfiguration "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetEmitTouchEventsForMouseConfiguration fromJson(JsonInput input) {
            return SetEmitTouchEventsForMouseConfiguration.fromString(input.nextString());
        }
    }
}

