/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.headlessexperimental.model;

import java.util.Arrays;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class ScreenshotParams {
    private final Optional<Format> format;
    private final Optional<Integer> quality;

    public ScreenshotParams(Optional<Format> format, Optional<Integer> quality) {
        this.format = format;
        this.quality = quality;
    }

    public Optional<Format> getFormat() {
        return this.format;
    }

    public Optional<Integer> getQuality() {
        return this.quality;
    }

    private static ScreenshotParams fromJson(JsonInput input) {
        Optional<Format> format = Optional.empty();
        Optional<Integer> quality = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "format": {
                    format = Optional.ofNullable(Format.fromString(input.nextString()));
                    continue block8;
                }
                case "quality": {
                    quality = Optional.ofNullable(input.nextNumber().intValue());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreenshotParams(format, quality);
    }

    public static enum Format {
        JPEG("jpeg"),
        PNG("png");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public static Format fromString(String s2) {
            return Arrays.stream(Format.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Format "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Format fromJson(JsonInput input) {
            return Format.fromString(input.nextString());
        }
    }
}

