/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ServiceWorkerResponseSource {
    CACHE_STORAGE("cache-storage"),
    HTTP_CACHE("http-cache"),
    FALLBACK_CODE("fallback-code"),
    NETWORK("network");

    private String value;

    private ServiceWorkerResponseSource(String value) {
        this.value = value;
    }

    public static ServiceWorkerResponseSource fromString(String s2) {
        return Arrays.stream(ServiceWorkerResponseSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ServiceWorkerResponseSource "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ServiceWorkerResponseSource fromJson(JsonInput input) {
        return ServiceWorkerResponseSource.fromString(input.nextString());
    }
}

