/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.serviceworker;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v89.serviceworker.model.RegistrationID;
import org.openqa.selenium.devtools.v89.serviceworker.model.ServiceWorkerErrorMessage;
import org.openqa.selenium.devtools.v89.serviceworker.model.ServiceWorkerRegistration;
import org.openqa.selenium.devtools.v89.serviceworker.model.ServiceWorkerVersion;

@Beta
public class ServiceWorker {
    public static Command<Void> deliverPushMessage(String origin, RegistrationID registrationId, String data) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(data, "data is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("data", data);
        return new Command<Void>("ServiceWorker.deliverPushMessage", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("ServiceWorker.disable", params.build());
    }

    public static Command<Void> dispatchSyncEvent(String origin, RegistrationID registrationId, String tag, Boolean lastChance) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        Objects.requireNonNull(lastChance, "lastChance is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        params.put("lastChance", lastChance);
        return new Command<Void>("ServiceWorker.dispatchSyncEvent", params.build());
    }

    public static Command<Void> dispatchPeriodicSyncEvent(String origin, RegistrationID registrationId, String tag) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(registrationId, "registrationId is required");
        Objects.requireNonNull(tag, "tag is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("registrationId", registrationId);
        params.put("tag", tag);
        return new Command<Void>("ServiceWorker.dispatchPeriodicSyncEvent", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("ServiceWorker.enable", params.build());
    }

    public static Command<Void> inspectWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("versionId", versionId);
        return new Command<Void>("ServiceWorker.inspectWorker", params.build());
    }

    public static Command<Void> setForceUpdateOnPageLoad(Boolean forceUpdateOnPageLoad) {
        Objects.requireNonNull(forceUpdateOnPageLoad, "forceUpdateOnPageLoad is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("forceUpdateOnPageLoad", forceUpdateOnPageLoad);
        return new Command<Void>("ServiceWorker.setForceUpdateOnPageLoad", params.build());
    }

    public static Command<Void> skipWaiting(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.skipWaiting", params.build());
    }

    public static Command<Void> startWorker(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.startWorker", params.build());
    }

    public static Command<Void> stopAllWorkers() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("ServiceWorker.stopAllWorkers", params.build());
    }

    public static Command<Void> stopWorker(String versionId) {
        Objects.requireNonNull(versionId, "versionId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("versionId", versionId);
        return new Command<Void>("ServiceWorker.stopWorker", params.build());
    }

    public static Command<Void> unregister(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.unregister", params.build());
    }

    public static Command<Void> updateRegistration(String scopeURL) {
        Objects.requireNonNull(scopeURL, "scopeURL is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("scopeURL", scopeURL);
        return new Command<Void>("ServiceWorker.updateRegistration", params.build());
    }

    public static Event<ServiceWorkerErrorMessage> workerErrorReported() {
        return new Event<ServiceWorkerErrorMessage>("ServiceWorker.workerErrorReported", ConverterFunctions.map("errorMessage", ServiceWorkerErrorMessage.class));
    }

    public static Event<List<ServiceWorkerRegistration>> workerRegistrationUpdated() {
        return new Event<List<ServiceWorkerRegistration>>("ServiceWorker.workerRegistrationUpdated", ConverterFunctions.map("registrations", new TypeToken<List<ServiceWorkerRegistration>>(){}.getType()));
    }

    public static Event<List<ServiceWorkerVersion>> workerVersionUpdated() {
        return new Event<List<ServiceWorkerVersion>>("ServiceWorker.workerVersionUpdated", ConverterFunctions.map("versions", new TypeToken<List<ServiceWorkerVersion>>(){}.getType()));
    }
}

