/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.serviceworker.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v89.serviceworker.model.RegistrationID;
import org.openqa.selenium.devtools.v89.serviceworker.model.ServiceWorkerVersionRunningStatus;
import org.openqa.selenium.devtools.v89.serviceworker.model.ServiceWorkerVersionStatus;
import org.openqa.selenium.devtools.v89.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class ServiceWorkerVersion {
    private final String versionId;
    private final RegistrationID registrationId;
    private final String scriptURL;
    private final ServiceWorkerVersionRunningStatus runningStatus;
    private final ServiceWorkerVersionStatus status;
    private final Optional<Number> scriptLastModified;
    private final Optional<Number> scriptResponseTime;
    private final Optional<List<TargetID>> controlledClients;
    private final Optional<TargetID> targetId;

    public ServiceWorkerVersion(String versionId, RegistrationID registrationId, String scriptURL, ServiceWorkerVersionRunningStatus runningStatus, ServiceWorkerVersionStatus status, Optional<Number> scriptLastModified, Optional<Number> scriptResponseTime, Optional<List<TargetID>> controlledClients, Optional<TargetID> targetId) {
        this.versionId = Objects.requireNonNull(versionId, "versionId is required");
        this.registrationId = Objects.requireNonNull(registrationId, "registrationId is required");
        this.scriptURL = Objects.requireNonNull(scriptURL, "scriptURL is required");
        this.runningStatus = Objects.requireNonNull(runningStatus, "runningStatus is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.scriptLastModified = scriptLastModified;
        this.scriptResponseTime = scriptResponseTime;
        this.controlledClients = controlledClients;
        this.targetId = targetId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public RegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public String getScriptURL() {
        return this.scriptURL;
    }

    public ServiceWorkerVersionRunningStatus getRunningStatus() {
        return this.runningStatus;
    }

    public ServiceWorkerVersionStatus getStatus() {
        return this.status;
    }

    public Optional<Number> getScriptLastModified() {
        return this.scriptLastModified;
    }

    public Optional<Number> getScriptResponseTime() {
        return this.scriptResponseTime;
    }

    public Optional<List<TargetID>> getControlledClients() {
        return this.controlledClients;
    }

    public Optional<TargetID> getTargetId() {
        return this.targetId;
    }

    private static ServiceWorkerVersion fromJson(JsonInput input) {
        String versionId = null;
        RegistrationID registrationId = null;
        String scriptURL = null;
        ServiceWorkerVersionRunningStatus runningStatus = null;
        ServiceWorkerVersionStatus status = null;
        Optional<Number> scriptLastModified = Optional.empty();
        Optional<Number> scriptResponseTime = Optional.empty();
        Optional<List<TargetID>> controlledClients = Optional.empty();
        Optional<TargetID> targetId = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "versionId": {
                    versionId = input.nextString();
                    continue block22;
                }
                case "registrationId": {
                    registrationId = (RegistrationID)input.read((Type)((Object)RegistrationID.class));
                    continue block22;
                }
                case "scriptURL": {
                    scriptURL = input.nextString();
                    continue block22;
                }
                case "runningStatus": {
                    runningStatus = (ServiceWorkerVersionRunningStatus)((Object)input.read((Type)((Object)ServiceWorkerVersionRunningStatus.class)));
                    continue block22;
                }
                case "status": {
                    status = (ServiceWorkerVersionStatus)((Object)input.read((Type)((Object)ServiceWorkerVersionStatus.class)));
                    continue block22;
                }
                case "scriptLastModified": {
                    scriptLastModified = Optional.ofNullable(input.nextNumber());
                    continue block22;
                }
                case "scriptResponseTime": {
                    scriptResponseTime = Optional.ofNullable(input.nextNumber());
                    continue block22;
                }
                case "controlledClients": {
                    controlledClients = Optional.ofNullable((List)input.read(new TypeToken<List<TargetID>>(){}.getType()));
                    continue block22;
                }
                case "targetId": {
                    targetId = Optional.ofNullable((TargetID)input.read((Type)((Object)TargetID.class)));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ServiceWorkerVersion(versionId, registrationId, scriptURL, runningStatus, status, scriptLastModified, scriptResponseTime, controlledClients, targetId);
    }
}

