/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v89.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v89.network.model.Cookie;
import org.openqa.selenium.devtools.v89.network.model.CookieParam;
import org.openqa.selenium.devtools.v89.storage.model.CacheStorageContentUpdated;
import org.openqa.selenium.devtools.v89.storage.model.IndexedDBContentUpdated;
import org.openqa.selenium.devtools.v89.storage.model.UsageForType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Storage {
    public static Command<Void> clearDataForOrigin(String origin, String storageTypes) {
        Objects.requireNonNull(origin, "origin is required");
        Objects.requireNonNull(storageTypes, "storageTypes is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        params.put("storageTypes", storageTypes);
        return new Command<Void>("Storage.clearDataForOrigin", params.build());
    }

    public static Command<List<Cookie>> getCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<List<Cookie>>("Storage.getCookies", params.build(), ConverterFunctions.map("cookies", new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies, Optional<BrowserContextID> browserContextId) {
        Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder<String, List<CookieParam>> params = ImmutableMap.builder();
        params.put("cookies", cookies);
        browserContextId.ifPresent(p -> params.put("browserContextId", (List<CookieParam>)p));
        return new Command<Void>("Storage.setCookies", params.build());
    }

    public static Command<Void> clearCookies(Optional<BrowserContextID> browserContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        browserContextId.ifPresent(p -> params.put("browserContextId", p));
        return new Command<Void>("Storage.clearCookies", params.build());
    }

    public static Command<GetUsageAndQuotaResponse> getUsageAndQuota(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<GetUsageAndQuotaResponse>("Storage.getUsageAndQuota", params.build(), input -> (GetUsageAndQuotaResponse)input.read((Type)((Object)GetUsageAndQuotaResponse.class)));
    }

    @Beta
    public static Command<Void> overrideQuotaForOrigin(String origin, Optional<Number> quotaSize) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        quotaSize.ifPresent(p -> params.put("quotaSize", (String)p));
        return new Command<Void>("Storage.overrideQuotaForOrigin", params.build());
    }

    public static Command<Void> trackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackCacheStorageForOrigin", params.build());
    }

    public static Command<Void> trackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.trackIndexedDBForOrigin", params.build());
    }

    public static Command<Void> untrackCacheStorageForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackCacheStorageForOrigin", params.build());
    }

    public static Command<Void> untrackIndexedDBForOrigin(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<Void>("Storage.untrackIndexedDBForOrigin", params.build());
    }

    public static Event<CacheStorageContentUpdated> cacheStorageContentUpdated() {
        return new Event<CacheStorageContentUpdated>("Storage.cacheStorageContentUpdated", input -> (CacheStorageContentUpdated)input.read((Type)((Object)CacheStorageContentUpdated.class)));
    }

    public static Event<String> cacheStorageListUpdated() {
        return new Event<String>("Storage.cacheStorageListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static Event<IndexedDBContentUpdated> indexedDBContentUpdated() {
        return new Event<IndexedDBContentUpdated>("Storage.indexedDBContentUpdated", input -> (IndexedDBContentUpdated)input.read((Type)((Object)IndexedDBContentUpdated.class)));
    }

    public static Event<String> indexedDBListUpdated() {
        return new Event<String>("Storage.indexedDBListUpdated", ConverterFunctions.map("origin", String.class));
    }

    public static class GetUsageAndQuotaResponse {
        private final Number usage;
        private final Number quota;
        private final Boolean overrideActive;
        private final List<UsageForType> usageBreakdown;

        public GetUsageAndQuotaResponse(Number usage, Number quota, Boolean overrideActive, List<UsageForType> usageBreakdown) {
            this.usage = Objects.requireNonNull(usage, "usage is required");
            this.quota = Objects.requireNonNull(quota, "quota is required");
            this.overrideActive = Objects.requireNonNull(overrideActive, "overrideActive is required");
            this.usageBreakdown = Objects.requireNonNull(usageBreakdown, "usageBreakdown is required");
        }

        public Number getUsage() {
            return this.usage;
        }

        public Number getQuota() {
            return this.quota;
        }

        public Boolean getOverrideActive() {
            return this.overrideActive;
        }

        public List<UsageForType> getUsageBreakdown() {
            return this.usageBreakdown;
        }

        private static GetUsageAndQuotaResponse fromJson(JsonInput input) {
            Number usage = 0;
            Number quota = 0;
            Boolean overrideActive = false;
            List usageBreakdown = null;
            input.beginObject();
            block12: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "usage": {
                        usage = input.nextNumber();
                        continue block12;
                    }
                    case "quota": {
                        quota = input.nextNumber();
                        continue block12;
                    }
                    case "overrideActive": {
                        overrideActive = input.nextBoolean();
                        continue block12;
                    }
                    case "usageBreakdown": {
                        usageBreakdown = (List)input.read(new TypeToken<List<UsageForType>>(){}.getType());
                        continue block12;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetUsageAndQuotaResponse(usage, quota, overrideActive, usageBreakdown);
        }
    }
}

