/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.animation;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v90.runtime.model.RemoteObject;

@Beta
public class Animation {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Animation.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Animation.enable", params.build());
    }

    public static Command<Number> getCurrentTime(String id) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("id", id);
        return new Command<Number>("Animation.getCurrentTime", params.build(), ConverterFunctions.map("currentTime", Number.class));
    }

    public static Command<Number> getPlaybackRate() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Number>("Animation.getPlaybackRate", params.build(), ConverterFunctions.map("playbackRate", Number.class));
    }

    public static Command<Void> releaseAnimations(List<String> animations) {
        Objects.requireNonNull(animations, "animations is required");
        ImmutableMap.Builder<String, List<String>> params = ImmutableMap.builder();
        params.put("animations", animations);
        return new Command<Void>("Animation.releaseAnimations", params.build());
    }

    public static Command<RemoteObject> resolveAnimation(String animationId) {
        Objects.requireNonNull(animationId, "animationId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("animationId", animationId);
        return new Command<RemoteObject>("Animation.resolveAnimation", params.build(), ConverterFunctions.map("remoteObject", RemoteObject.class));
    }

    public static Command<Void> seekAnimations(List<String> animations, Number currentTime) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(currentTime, "currentTime is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("animations", animations);
        params.put("currentTime", currentTime);
        return new Command<Void>("Animation.seekAnimations", params.build());
    }

    public static Command<Void> setPaused(List<String> animations, Boolean paused) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(paused, "paused is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("animations", animations);
        params.put("paused", paused);
        return new Command<Void>("Animation.setPaused", params.build());
    }

    public static Command<Void> setPlaybackRate(Number playbackRate) {
        Objects.requireNonNull(playbackRate, "playbackRate is required");
        ImmutableMap.Builder<String, Number> params = ImmutableMap.builder();
        params.put("playbackRate", playbackRate);
        return new Command<Void>("Animation.setPlaybackRate", params.build());
    }

    public static Command<Void> setTiming(String animationId, Number duration, Number delay) {
        Objects.requireNonNull(animationId, "animationId is required");
        Objects.requireNonNull(duration, "duration is required");
        Objects.requireNonNull(delay, "delay is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("animationId", animationId);
        params.put("duration", duration);
        params.put("delay", delay);
        return new Command<Void>("Animation.setTiming", params.build());
    }

    public static Event<String> animationCanceled() {
        return new Event<String>("Animation.animationCanceled", ConverterFunctions.map("id", String.class));
    }

    public static Event<String> animationCreated() {
        return new Event<String>("Animation.animationCreated", ConverterFunctions.map("id", String.class));
    }

    public static Event<org.openqa.selenium.devtools.v90.animation.model.Animation> animationStarted() {
        return new Event<org.openqa.selenium.devtools.v90.animation.model.Animation>("Animation.animationStarted", ConverterFunctions.map("animation", org.openqa.selenium.devtools.v90.animation.model.Animation.class));
    }
}

