/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v90.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v90.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v90.audits.model.BlockedByResponseReason;
import org.openqa.selenium.json.JsonInput;

public class BlockedByResponseIssueDetails {
    private final AffectedRequest request;
    private final Optional<AffectedFrame> parentFrame;
    private final Optional<AffectedFrame> blockedFrame;
    private final BlockedByResponseReason reason;

    public BlockedByResponseIssueDetails(AffectedRequest request, Optional<AffectedFrame> parentFrame, Optional<AffectedFrame> blockedFrame, BlockedByResponseReason reason) {
        this.request = Objects.requireNonNull(request, "request is required");
        this.parentFrame = parentFrame;
        this.blockedFrame = blockedFrame;
        this.reason = Objects.requireNonNull(reason, "reason is required");
    }

    public AffectedRequest getRequest() {
        return this.request;
    }

    public Optional<AffectedFrame> getParentFrame() {
        return this.parentFrame;
    }

    public Optional<AffectedFrame> getBlockedFrame() {
        return this.blockedFrame;
    }

    public BlockedByResponseReason getReason() {
        return this.reason;
    }

    private static BlockedByResponseIssueDetails fromJson(JsonInput input) {
        AffectedRequest request = null;
        Optional<AffectedFrame> parentFrame = Optional.empty();
        Optional<AffectedFrame> blockedFrame = Optional.empty();
        BlockedByResponseReason reason = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    request = (AffectedRequest)input.read((Type)((Object)AffectedRequest.class));
                    continue block12;
                }
                case "parentFrame": {
                    parentFrame = Optional.ofNullable((AffectedFrame)input.read((Type)((Object)AffectedFrame.class)));
                    continue block12;
                }
                case "blockedFrame": {
                    blockedFrame = Optional.ofNullable((AffectedFrame)input.read((Type)((Object)AffectedFrame.class)));
                    continue block12;
                }
                case "reason": {
                    reason = (BlockedByResponseReason)((Object)input.read((Type)((Object)BlockedByResponseReason.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BlockedByResponseIssueDetails(request, parentFrame, blockedFrame, reason);
    }
}

