/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.dom.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v90.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class BackendNode {
    private final Integer nodeType;
    private final String nodeName;
    private final BackendNodeId backendNodeId;

    public BackendNode(Integer nodeType, String nodeName, BackendNodeId backendNodeId) {
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    private static BackendNode fromJson(JsonInput input) {
        Integer nodeType = 0;
        String nodeName = null;
        BackendNodeId backendNodeId = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeType": {
                    nodeType = input.nextNumber().intValue();
                    continue block10;
                }
                case "nodeName": {
                    nodeName = input.nextString();
                    continue block10;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BackendNode(nodeType, nodeName, backendNodeId);
    }
}

