/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.fetch.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v90.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v90.fetch.model.RequestId;
import org.openqa.selenium.devtools.v90.network.model.ErrorReason;
import org.openqa.selenium.devtools.v90.network.model.Request;
import org.openqa.selenium.devtools.v90.network.model.ResourceType;
import org.openqa.selenium.devtools.v90.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestPaused {
    private final RequestId requestId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final Optional<ErrorReason> responseErrorReason;
    private final Optional<Integer> responseStatusCode;
    private final Optional<List<HeaderEntry>> responseHeaders;
    private final Optional<RequestId> networkId;

    public RequestPaused(RequestId requestId, Request request, FrameId frameId, ResourceType resourceType, Optional<ErrorReason> responseErrorReason, Optional<Integer> responseStatusCode, Optional<List<HeaderEntry>> responseHeaders, Optional<RequestId> networkId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is required");
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseHeaders = responseHeaders;
        this.networkId = networkId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Optional<ErrorReason> getResponseErrorReason() {
        return this.responseErrorReason;
    }

    public Optional<Integer> getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Optional<List<HeaderEntry>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Optional<RequestId> getNetworkId() {
        return this.networkId;
    }

    private static RequestPaused fromJson(JsonInput input) {
        RequestId requestId = null;
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        Optional<ErrorReason> responseErrorReason = Optional.empty();
        Optional<Integer> responseStatusCode = Optional.empty();
        Optional<List<HeaderEntry>> responseHeaders = Optional.empty();
        Optional<RequestId> networkId = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block20;
                }
                case "request": {
                    request = (Request)input.read((Type)((Object)Request.class));
                    continue block20;
                }
                case "frameId": {
                    frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block20;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read((Type)((Object)ResourceType.class)));
                    continue block20;
                }
                case "responseErrorReason": {
                    responseErrorReason = Optional.ofNullable((ErrorReason)((Object)input.read((Type)((Object)ErrorReason.class))));
                    continue block20;
                }
                case "responseStatusCode": {
                    responseStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block20;
                }
                case "responseHeaders": {
                    responseHeaders = Optional.ofNullable((List)input.read(new TypeToken<List<HeaderEntry>>(){}.getType()));
                    continue block20;
                }
                case "networkId": {
                    networkId = Optional.ofNullable((RequestId)input.read((Type)((Object)RequestId.class)));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestPaused(requestId, request, frameId, resourceType, responseErrorReason, responseStatusCode, responseHeaders, networkId);
    }
}

