/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v90.network.model.LoaderId;
import org.openqa.selenium.devtools.v90.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v90.network.model.RequestId;
import org.openqa.selenium.devtools.v90.network.model.ResourceType;
import org.openqa.selenium.devtools.v90.network.model.Response;
import org.openqa.selenium.devtools.v90.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class ResponseReceived {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final Response response;
    private final Optional<FrameId> frameId;

    public ResponseReceived(RequestId requestId, LoaderId loaderId, MonotonicTime timestamp, ResourceType type, Response response, Optional<FrameId> frameId) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.response = Objects.requireNonNull(response, "response is required");
        this.frameId = frameId;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getType() {
        return this.type;
    }

    public Response getResponse() {
        return this.response;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    private static ResponseReceived fromJson(JsonInput input) {
        RequestId requestId = null;
        LoaderId loaderId = null;
        MonotonicTime timestamp = null;
        ResourceType type = null;
        Response response = null;
        Optional<FrameId> frameId = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block16;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read((Type)((Object)LoaderId.class));
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read((Type)((Object)MonotonicTime.class));
                    continue block16;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read((Type)((Object)ResourceType.class)));
                    continue block16;
                }
                case "response": {
                    response = (Response)input.read((Type)((Object)Response.class));
                    continue block16;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read((Type)((Object)FrameId.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseReceived(requestId, loaderId, timestamp, type, response, frameId);
    }
}

