/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.overlay;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v90.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v90.dom.model.NodeId;
import org.openqa.selenium.devtools.v90.dom.model.Quad;
import org.openqa.selenium.devtools.v90.dom.model.RGBA;
import org.openqa.selenium.devtools.v90.overlay.model.ColorFormat;
import org.openqa.selenium.devtools.v90.overlay.model.FlexNodeHighlightConfig;
import org.openqa.selenium.devtools.v90.overlay.model.GridNodeHighlightConfig;
import org.openqa.selenium.devtools.v90.overlay.model.HighlightConfig;
import org.openqa.selenium.devtools.v90.overlay.model.HingeConfig;
import org.openqa.selenium.devtools.v90.overlay.model.InspectMode;
import org.openqa.selenium.devtools.v90.overlay.model.SourceOrderConfig;
import org.openqa.selenium.devtools.v90.page.model.FrameId;
import org.openqa.selenium.devtools.v90.page.model.Viewport;
import org.openqa.selenium.devtools.v90.runtime.model.RemoteObjectId;

@Beta
public class Overlay {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.enable", params.build());
    }

    public static Command<Map<String, Object>> getHighlightObjectForTest(NodeId nodeId, Optional<Boolean> includeDistance, Optional<Boolean> includeStyle, Optional<ColorFormat> colorFormat, Optional<Boolean> showAccessibilityInfo) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        includeDistance.ifPresent(p -> params.put("includeDistance", (NodeId)p));
        includeStyle.ifPresent(p -> params.put("includeStyle", (NodeId)p));
        colorFormat.ifPresent(p -> params.put("colorFormat", (NodeId)p));
        showAccessibilityInfo.ifPresent(p -> params.put("showAccessibilityInfo", (NodeId)p));
        return new Command<Map<String, Object>>("Overlay.getHighlightObjectForTest", params.build(), ConverterFunctions.map("highlight", new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Map<String, Object>> getGridHighlightObjectsForTest(List<NodeId> nodeIds) {
        Objects.requireNonNull(nodeIds, "nodeIds is required");
        ImmutableMap.Builder<String, List<NodeId>> params = ImmutableMap.builder();
        params.put("nodeIds", nodeIds);
        return new Command<Map<String, Object>>("Overlay.getGridHighlightObjectsForTest", params.build(), ConverterFunctions.map("highlights", new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Map<String, Object>> getSourceOrderHighlightObjectForTest(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<Map<String, Object>>("Overlay.getSourceOrderHighlightObjectForTest", params.build(), ConverterFunctions.map("highlight", new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.hideHighlight", params.build());
    }

    public static Command<Void> highlightFrame(FrameId frameId, Optional<RGBA> contentColor, Optional<RGBA> contentOutlineColor) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, FrameId> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        contentColor.ifPresent(p -> params.put("contentColor", (FrameId)p));
        contentOutlineColor.ifPresent(p -> params.put("contentOutlineColor", (FrameId)p));
        return new Command<Void>("Overlay.highlightFrame", params.build());
    }

    public static Command<Void> highlightNode(HighlightConfig highlightConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> selector) {
        Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        ImmutableMap.Builder<String, HighlightConfig> params = ImmutableMap.builder();
        params.put("highlightConfig", highlightConfig);
        nodeId.ifPresent(p -> params.put("nodeId", (HighlightConfig)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (HighlightConfig)p));
        objectId.ifPresent(p -> params.put("objectId", (HighlightConfig)p));
        selector.ifPresent(p -> params.put("selector", (HighlightConfig)p));
        return new Command<Void>("Overlay.highlightNode", params.build());
    }

    public static Command<Void> highlightQuad(Quad quad, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(quad, "quad is required");
        ImmutableMap.Builder<String, Quad> params = ImmutableMap.builder();
        params.put("quad", quad);
        color.ifPresent(p -> params.put("color", (Quad)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Quad)p));
        return new Command<Void>("Overlay.highlightQuad", params.build());
    }

    public static Command<Void> highlightRect(Integer x, Integer y, Integer width, Integer height, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        params.put("width", width);
        params.put("height", height);
        color.ifPresent(p -> params.put("color", (Integer)p));
        outlineColor.ifPresent(p -> params.put("outlineColor", (Integer)p));
        return new Command<Void>("Overlay.highlightRect", params.build());
    }

    public static Command<Void> highlightSourceOrder(SourceOrderConfig sourceOrderConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(sourceOrderConfig, "sourceOrderConfig is required");
        ImmutableMap.Builder<String, SourceOrderConfig> params = ImmutableMap.builder();
        params.put("sourceOrderConfig", sourceOrderConfig);
        nodeId.ifPresent(p -> params.put("nodeId", (SourceOrderConfig)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (SourceOrderConfig)p));
        objectId.ifPresent(p -> params.put("objectId", (SourceOrderConfig)p));
        return new Command<Void>("Overlay.highlightSourceOrder", params.build());
    }

    public static Command<Void> setInspectMode(InspectMode mode, Optional<HighlightConfig> highlightConfig) {
        Objects.requireNonNull(mode, "mode is required");
        ImmutableMap.Builder<String, InspectMode> params = ImmutableMap.builder();
        params.put("mode", mode);
        highlightConfig.ifPresent(p -> params.put("highlightConfig", (InspectMode)((Object)p)));
        return new Command<Void>("Overlay.setInspectMode", params.build());
    }

    public static Command<Void> setShowAdHighlights(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowAdHighlights", params.build());
    }

    public static Command<Void> setPausedInDebuggerMessage(Optional<String> message) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        message.ifPresent(p -> params.put("message", p));
        return new Command<Void>("Overlay.setPausedInDebuggerMessage", params.build());
    }

    public static Command<Void> setShowDebugBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowDebugBorders", params.build());
    }

    public static Command<Void> setShowFPSCounter(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowFPSCounter", params.build());
    }

    public static Command<Void> setShowGridOverlays(List<GridNodeHighlightConfig> gridNodeHighlightConfigs) {
        Objects.requireNonNull(gridNodeHighlightConfigs, "gridNodeHighlightConfigs is required");
        ImmutableMap.Builder<String, List<GridNodeHighlightConfig>> params = ImmutableMap.builder();
        params.put("gridNodeHighlightConfigs", gridNodeHighlightConfigs);
        return new Command<Void>("Overlay.setShowGridOverlays", params.build());
    }

    public static Command<Void> setShowFlexOverlays(List<FlexNodeHighlightConfig> flexNodeHighlightConfigs) {
        Objects.requireNonNull(flexNodeHighlightConfigs, "flexNodeHighlightConfigs is required");
        ImmutableMap.Builder<String, List<FlexNodeHighlightConfig>> params = ImmutableMap.builder();
        params.put("flexNodeHighlightConfigs", flexNodeHighlightConfigs);
        return new Command<Void>("Overlay.setShowFlexOverlays", params.build());
    }

    public static Command<Void> setShowPaintRects(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("result", result);
        return new Command<Void>("Overlay.setShowPaintRects", params.build());
    }

    public static Command<Void> setShowLayoutShiftRegions(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("result", result);
        return new Command<Void>("Overlay.setShowLayoutShiftRegions", params.build());
    }

    public static Command<Void> setShowScrollBottleneckRects(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowScrollBottleneckRects", params.build());
    }

    public static Command<Void> setShowHitTestBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowHitTestBorders", params.build());
    }

    public static Command<Void> setShowWebVitals(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowWebVitals", params.build());
    }

    public static Command<Void> setShowViewportSizeOnResize(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("show", show);
        return new Command<Void>("Overlay.setShowViewportSizeOnResize", params.build());
    }

    public static Command<Void> setShowHinge(Optional<HingeConfig> hingeConfig) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        hingeConfig.ifPresent(p -> params.put("hingeConfig", p));
        return new Command<Void>("Overlay.setShowHinge", params.build());
    }

    public static Event<BackendNodeId> inspectNodeRequested() {
        return new Event<BackendNodeId>("Overlay.inspectNodeRequested", ConverterFunctions.map("backendNodeId", BackendNodeId.class));
    }

    public static Event<NodeId> nodeHighlightRequested() {
        return new Event<NodeId>("Overlay.nodeHighlightRequested", ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Event<Viewport> screenshotRequested() {
        return new Event<Viewport>("Overlay.screenshotRequested", ConverterFunctions.map("viewport", Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event<Void>("Overlay.inspectModeCanceled", input -> null);
    }
}

