/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.runtime.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v90.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v90.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v90.runtime.model.ScriptId;
import org.openqa.selenium.devtools.v90.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class ExceptionDetails {
    private final Integer exceptionId;
    private final String text;
    private final Integer lineNumber;
    private final Integer columnNumber;
    private final Optional<ScriptId> scriptId;
    private final Optional<String> url;
    private final Optional<StackTrace> stackTrace;
    private final Optional<RemoteObject> exception;
    private final Optional<ExecutionContextId> executionContextId;

    public ExceptionDetails(Integer exceptionId, String text, Integer lineNumber, Integer columnNumber, Optional<ScriptId> scriptId, Optional<String> url, Optional<StackTrace> stackTrace, Optional<RemoteObject> exception, Optional<ExecutionContextId> executionContextId) {
        this.exceptionId = Objects.requireNonNull(exceptionId, "exceptionId is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
        this.scriptId = scriptId;
        this.url = url;
        this.stackTrace = stackTrace;
        this.exception = exception;
        this.executionContextId = executionContextId;
    }

    public Integer getExceptionId() {
        return this.exceptionId;
    }

    public String getText() {
        return this.text;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    public Optional<ScriptId> getScriptId() {
        return this.scriptId;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<StackTrace> getStackTrace() {
        return this.stackTrace;
    }

    public Optional<RemoteObject> getException() {
        return this.exception;
    }

    public Optional<ExecutionContextId> getExecutionContextId() {
        return this.executionContextId;
    }

    private static ExceptionDetails fromJson(JsonInput input) {
        Integer exceptionId = 0;
        String text = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        Optional<ScriptId> scriptId = Optional.empty();
        Optional<String> url = Optional.empty();
        Optional<StackTrace> stackTrace = Optional.empty();
        Optional<RemoteObject> exception = Optional.empty();
        Optional<ExecutionContextId> executionContextId = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "exceptionId": {
                    exceptionId = input.nextNumber().intValue();
                    continue block22;
                }
                case "text": {
                    text = input.nextString();
                    continue block22;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block22;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block22;
                }
                case "scriptId": {
                    scriptId = Optional.ofNullable((ScriptId)input.read((Type)((Object)ScriptId.class)));
                    continue block22;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "stackTrace": {
                    stackTrace = Optional.ofNullable((StackTrace)input.read((Type)((Object)StackTrace.class)));
                    continue block22;
                }
                case "exception": {
                    exception = Optional.ofNullable((RemoteObject)input.read((Type)((Object)RemoteObject.class)));
                    continue block22;
                }
                case "executionContextId": {
                    executionContextId = Optional.ofNullable((ExecutionContextId)input.read((Type)((Object)ExecutionContextId.class)));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExceptionDetails(exceptionId, text, lineNumber, columnNumber, scriptId, url, stackTrace, exception, executionContextId);
    }
}

