/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v90.security;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v90.security.model.CertificateError;
import org.openqa.selenium.devtools.v90.security.model.CertificateErrorAction;
import org.openqa.selenium.devtools.v90.security.model.SecurityStateChanged;
import org.openqa.selenium.devtools.v90.security.model.VisibleSecurityState;

public class Security {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Security.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Security.enable", params.build());
    }

    @Beta
    public static Command<Void> setIgnoreCertificateErrors(Boolean ignore) {
        Objects.requireNonNull(ignore, "ignore is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("ignore", ignore);
        return new Command<Void>("Security.setIgnoreCertificateErrors", params.build());
    }

    @Deprecated
    public static Command<Void> handleCertificateError(Integer eventId, CertificateErrorAction action) {
        Objects.requireNonNull(eventId, "eventId is required");
        Objects.requireNonNull(action, "action is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("eventId", eventId);
        params.put("action", (Object)action);
        return new Command<Void>("Security.handleCertificateError", params.build());
    }

    @Deprecated
    public static Command<Void> setOverrideCertificateErrors(Boolean override) {
        Objects.requireNonNull(override, "override is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("override", override);
        return new Command<Void>("Security.setOverrideCertificateErrors", params.build());
    }

    public static Event<CertificateError> certificateError() {
        return new Event<CertificateError>("Security.certificateError", input -> (CertificateError)input.read((Type)((Object)CertificateError.class)));
    }

    public static Event<VisibleSecurityState> visibleSecurityStateChanged() {
        return new Event<VisibleSecurityState>("Security.visibleSecurityStateChanged", ConverterFunctions.map("visibleSecurityState", VisibleSecurityState.class));
    }

    public static Event<SecurityStateChanged> securityStateChanged() {
        return new Event<SecurityStateChanged>("Security.securityStateChanged", input -> (SecurityStateChanged)input.read((Type)((Object)SecurityStateChanged.class)));
    }
}

