/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v91.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v91.network.model.ClientSecurityState;
import org.openqa.selenium.devtools.v91.network.model.CorsErrorStatus;
import org.openqa.selenium.devtools.v91.network.model.IPAddressSpace;
import org.openqa.selenium.json.JsonInput;

public class CorsIssueDetails {
    private final CorsErrorStatus corsErrorStatus;
    private final Boolean isWarning;
    private final AffectedRequest request;
    private final Optional<String> initiatorOrigin;
    private final Optional<IPAddressSpace> resourceIPAddressSpace;
    private final Optional<ClientSecurityState> clientSecurityState;

    public CorsIssueDetails(CorsErrorStatus corsErrorStatus, Boolean isWarning, AffectedRequest request, Optional<String> initiatorOrigin, Optional<IPAddressSpace> resourceIPAddressSpace, Optional<ClientSecurityState> clientSecurityState) {
        this.corsErrorStatus = Objects.requireNonNull(corsErrorStatus, "corsErrorStatus is required");
        this.isWarning = Objects.requireNonNull(isWarning, "isWarning is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.initiatorOrigin = initiatorOrigin;
        this.resourceIPAddressSpace = resourceIPAddressSpace;
        this.clientSecurityState = clientSecurityState;
    }

    public CorsErrorStatus getCorsErrorStatus() {
        return this.corsErrorStatus;
    }

    public Boolean getIsWarning() {
        return this.isWarning;
    }

    public AffectedRequest getRequest() {
        return this.request;
    }

    public Optional<String> getInitiatorOrigin() {
        return this.initiatorOrigin;
    }

    public Optional<IPAddressSpace> getResourceIPAddressSpace() {
        return this.resourceIPAddressSpace;
    }

    public Optional<ClientSecurityState> getClientSecurityState() {
        return this.clientSecurityState;
    }

    private static CorsIssueDetails fromJson(JsonInput input) {
        CorsErrorStatus corsErrorStatus = null;
        Boolean isWarning = false;
        AffectedRequest request = null;
        Optional<String> initiatorOrigin = Optional.empty();
        Optional<IPAddressSpace> resourceIPAddressSpace = Optional.empty();
        Optional<ClientSecurityState> clientSecurityState = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "corsErrorStatus": {
                    corsErrorStatus = (CorsErrorStatus)input.read((Type)((Object)CorsErrorStatus.class));
                    continue block16;
                }
                case "isWarning": {
                    isWarning = input.nextBoolean();
                    continue block16;
                }
                case "request": {
                    request = (AffectedRequest)input.read((Type)((Object)AffectedRequest.class));
                    continue block16;
                }
                case "initiatorOrigin": {
                    initiatorOrigin = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "resourceIPAddressSpace": {
                    resourceIPAddressSpace = Optional.ofNullable((IPAddressSpace)((Object)input.read((Type)((Object)IPAddressSpace.class))));
                    continue block16;
                }
                case "clientSecurityState": {
                    clientSecurityState = Optional.ofNullable((ClientSecurityState)input.read((Type)((Object)ClientSecurityState.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CorsIssueDetails(corsErrorStatus, isWarning, request, initiatorOrigin, resourceIPAddressSpace, clientSecurityState);
    }
}

