/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.devtools.v91.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class LowTextContrastIssueDetails {
    private final BackendNodeId violatingNodeId;
    private final String violatingNodeSelector;
    private final Number contrastRatio;
    private final Number thresholdAA;
    private final Number thresholdAAA;
    private final String fontSize;
    private final String fontWeight;

    public LowTextContrastIssueDetails(BackendNodeId violatingNodeId, String violatingNodeSelector, Number contrastRatio, Number thresholdAA, Number thresholdAAA, String fontSize, String fontWeight) {
        this.violatingNodeId = Objects.requireNonNull(violatingNodeId, "violatingNodeId is required");
        this.violatingNodeSelector = Objects.requireNonNull(violatingNodeSelector, "violatingNodeSelector is required");
        this.contrastRatio = Objects.requireNonNull(contrastRatio, "contrastRatio is required");
        this.thresholdAA = Objects.requireNonNull(thresholdAA, "thresholdAA is required");
        this.thresholdAAA = Objects.requireNonNull(thresholdAAA, "thresholdAAA is required");
        this.fontSize = Objects.requireNonNull(fontSize, "fontSize is required");
        this.fontWeight = Objects.requireNonNull(fontWeight, "fontWeight is required");
    }

    public BackendNodeId getViolatingNodeId() {
        return this.violatingNodeId;
    }

    public String getViolatingNodeSelector() {
        return this.violatingNodeSelector;
    }

    public Number getContrastRatio() {
        return this.contrastRatio;
    }

    public Number getThresholdAA() {
        return this.thresholdAA;
    }

    public Number getThresholdAAA() {
        return this.thresholdAAA;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    private static LowTextContrastIssueDetails fromJson(JsonInput input) {
        BackendNodeId violatingNodeId = null;
        String violatingNodeSelector = null;
        Number contrastRatio = 0;
        Number thresholdAA = 0;
        Number thresholdAAA = 0;
        String fontSize = null;
        String fontWeight = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "violatingNodeId": {
                    violatingNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                    continue block18;
                }
                case "violatingNodeSelector": {
                    violatingNodeSelector = input.nextString();
                    continue block18;
                }
                case "contrastRatio": {
                    contrastRatio = input.nextNumber();
                    continue block18;
                }
                case "thresholdAA": {
                    thresholdAA = input.nextNumber();
                    continue block18;
                }
                case "thresholdAAA": {
                    thresholdAAA = input.nextNumber();
                    continue block18;
                }
                case "fontSize": {
                    fontSize = input.nextString();
                    continue block18;
                }
                case "fontWeight": {
                    fontWeight = input.nextString();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LowTextContrastIssueDetails(violatingNodeId, violatingNodeSelector, contrastRatio, thresholdAA, thresholdAAA, fontSize, fontWeight);
    }
}

