/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.performancetimeline.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v91.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v91.performancetimeline.model.LayoutShiftAttribution;
import org.openqa.selenium.json.JsonInput;

public class LayoutShift {
    private final Number value;
    private final Boolean hadRecentInput;
    private final TimeSinceEpoch lastInputTime;
    private final List<LayoutShiftAttribution> sources;

    public LayoutShift(Number value, Boolean hadRecentInput, TimeSinceEpoch lastInputTime, List<LayoutShiftAttribution> sources) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.hadRecentInput = Objects.requireNonNull(hadRecentInput, "hadRecentInput is required");
        this.lastInputTime = Objects.requireNonNull(lastInputTime, "lastInputTime is required");
        this.sources = Objects.requireNonNull(sources, "sources is required");
    }

    public Number getValue() {
        return this.value;
    }

    public Boolean getHadRecentInput() {
        return this.hadRecentInput;
    }

    public TimeSinceEpoch getLastInputTime() {
        return this.lastInputTime;
    }

    public List<LayoutShiftAttribution> getSources() {
        return this.sources;
    }

    private static LayoutShift fromJson(JsonInput input) {
        Number value = 0;
        Boolean hadRecentInput = false;
        TimeSinceEpoch lastInputTime = null;
        List sources = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = input.nextNumber();
                    continue block12;
                }
                case "hadRecentInput": {
                    hadRecentInput = input.nextBoolean();
                    continue block12;
                }
                case "lastInputTime": {
                    lastInputTime = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block12;
                }
                case "sources": {
                    sources = (List)input.read(new TypeToken<List<LayoutShiftAttribution>>(){}.getType());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutShift(value, hadRecentInput, lastInputTime, sources);
    }
}

