/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;

class DockerMessages {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(DockerMessages.class.getName());

    private DockerMessages() {
    }

    public static HttpResponse throwIfNecessary(HttpResponse response, String message, Object ... args) {
        String exceptionMessage;
        Require.nonNull("Response", response);
        if (response.isSuccessful()) {
            return response;
        }
        String userMessage = String.format(message, args);
        try {
            Map value = (Map)JSON.toType(Contents.string(response), Json.MAP_TYPE);
            message = (String)value.get("message");
            exceptionMessage = userMessage + "\n" + message;
        }
        catch (Exception e) {
            exceptionMessage = userMessage;
        }
        LOG.warning(exceptionMessage);
        throw new DockerException(exceptionMessage);
    }
}

