/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.internal.Reference;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class PullImage {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(PullImage.class.getName());
    private final HttpHandler client;

    public PullImage(HttpHandler client) {
        this.client = Require.nonNull("HTTP client", client);
    }

    public void apply(Reference ref) {
        Require.nonNull("Reference to pull", ref);
        LOG.info("Pulling " + ref);
        HttpRequest req = ((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.POST, "/v1.40/images/create").addHeader("Content-Type", "application/json; charset=utf-8")).addHeader("Content-Length", "0")).addQueryParameter("fromImage", String.format("%s/%s", ref.getRepository(), ref.getName()));
        if (ref.getDigest() != null) {
            req.addQueryParameter("tag", ref.getDigest());
        } else if (ref.getTag() != null) {
            req.addQueryParameter("tag", ref.getTag());
        }
        HttpResponse res = this.client.execute(req);
        LOG.info("Have response from server");
        if (!res.isSuccessful()) {
            String message = "Unable to pull image: " + ref.getFamiliarName();
            try {
                Map value = (Map)JSON.toType(Contents.string(res), Json.MAP_TYPE);
                message = (String)value.get("message");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DockerException(message);
        }
    }
}

