/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import com.google.common.collect.EvictingQueue;
import java.lang.reflect.Type;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.events.zeromq.ZeroMqEventBus;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

class UnboundZmqEventBus
implements EventBus {
    static final EventName REJECTED_EVENT = new EventName("selenium-rejected-event");
    private static final Logger LOG = Logger.getLogger(EventBus.class.getName());
    private static final Json JSON = new Json();
    private final ScheduledExecutorService socketPollingExecutor;
    private final ExecutorService listenerNotificationExecutor;
    private final Map<EventName, List<Consumer<Event>>> listeners = new ConcurrentHashMap<EventName, List<Consumer<Event>>>();
    private final Queue<UUID> recentMessages = EvictingQueue.create(128);
    private final String encodedSecret;
    private ZMQ.Socket pub;
    private ZMQ.Socket sub;

    UnboundZmqEventBus(ZContext context, String publishConnection, String subscribeConnection, Secret secret) {
        Require.nonNull("Secret", secret);
        StringBuilder builder = new StringBuilder();
        try (JsonOutput out = JSON.newOutput(builder);){
            out.setPrettyPrint(false).writeClassName(false).write(secret);
        }
        this.encodedSecret = builder.toString();
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r);
            thread.setName("Event Bus");
            thread.setDaemon(true);
            return thread;
        };
        this.socketPollingExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.listenerNotificationExecutor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() / 2, 2), threadFactory);
        String connectionMessage = String.format("Connecting to %s and %s", publishConnection, subscribeConnection);
        LOG.info(connectionMessage);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxAttempts(5).withDelay(5L, 10L, ChronoUnit.SECONDS).onFailedAttempt(e -> LOG.log(Level.WARNING, String.format("%s failed", connectionMessage))).onRetry(e -> LOG.log(Level.WARNING, String.format("Failure #%s. Retrying.", e.getAttemptCount()))).onRetriesExceeded(e -> LOG.log(Level.WARNING, "Connection aborted."));
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).run(() -> {
            this.sub = context.createSocket(SocketType.SUB);
            this.sub.setIPv6(this.isSubAddressIPv6(publishConnection));
            this.sub.connect(publishConnection);
            this.sub.subscribe(new byte[0]);
            this.pub = context.createSocket(SocketType.PUB);
            this.pub.setIPv6(this.isSubAddressIPv6(subscribeConnection));
            this.pub.connect(subscribeConnection);
        });
        ZMQ.Poller poller = context.createPoller(1);
        poller.register(Objects.requireNonNull(this.sub), 1);
        LOG.info("Sockets created");
        AtomicBoolean pollingStarted = new AtomicBoolean(false);
        this.socketPollingExecutor.scheduleWithFixedDelay(() -> this.pollForIncomingEvents(poller, secret, pollingStarted), 0L, 100L, TimeUnit.MILLISECONDS);
        while (!pollingStarted.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e2);
            }
        }
        LOG.info("Event bus ready");
    }

    @Override
    public boolean isReady() {
        return !this.socketPollingExecutor.isShutdown();
    }

    private boolean isSubAddressIPv6(String connection) {
        try {
            URI uri = new URI(connection);
            if ("inproc".equals(uri.getScheme())) {
                return false;
            }
            return InetAddress.getByName(uri.getHost()) instanceof Inet6Address;
        }
        catch (URISyntaxException | UnknownHostException e) {
            LOG.log(Level.WARNING, String.format("Could not determine if the address %s is IPv6 or IPv4", connection), e);
            return false;
        }
    }

    @Override
    public void addListener(EventListener<?> listener) {
        Require.nonNull("Listener", listener);
        List typeListeners = this.listeners.computeIfAbsent(listener.getEventName(), t -> new LinkedList());
        typeListeners.add(listener);
    }

    @Override
    public void fire(Event event) {
        Require.nonNull("Event to send", event);
        this.socketPollingExecutor.execute(() -> {
            this.pub.sendMore(event.getType().getName().getBytes(StandardCharsets.UTF_8));
            this.pub.sendMore(this.encodedSecret.getBytes(StandardCharsets.UTF_8));
            this.pub.sendMore(event.getId().toString().getBytes(StandardCharsets.UTF_8));
            this.pub.send(event.getRawData().getBytes(StandardCharsets.UTF_8));
        });
    }

    @Override
    public void close() {
        this.socketPollingExecutor.shutdownNow();
        this.listenerNotificationExecutor.shutdownNow();
        if (this.sub != null) {
            this.sub.close();
        }
        if (this.pub != null) {
            this.pub.close();
        }
    }

    private void pollForIncomingEvents(ZMQ.Poller poller, Secret secret, AtomicBoolean pollingStarted) {
        try {
            int count = poller.poll(0L);
            pollingStarted.lazySet(true);
            for (int i = 0; i < count; ++i) {
                if (!poller.pollin(i)) continue;
                ZMQ.Socket socket = poller.getSocket(i);
                EventName eventName = new EventName(new String(socket.recv(), StandardCharsets.UTF_8));
                Secret eventSecret = (Secret)JSON.toType(new String(socket.recv(), StandardCharsets.UTF_8), (Type)((Object)Secret.class));
                UUID id = UUID.fromString(new String(socket.recv(), StandardCharsets.UTF_8));
                String data = new String(socket.recv(), StandardCharsets.UTF_8);
                if (this.recentMessages.contains(id)) {
                    return;
                }
                Object converted = JSON.toType(data, (Type)((Object)Object.class));
                Event event = new Event(id, eventName, converted);
                this.recentMessages.add(id);
                if (!Secret.matches(secret, eventSecret)) {
                    LOG.severe(String.format("Received message without a valid secret. Rejecting. %s -> %s", event, data));
                    Event rejectedEvent = new Event(REJECTED_EVENT, new ZeroMqEventBus.RejectedEvent(eventName, data));
                    this.notifyListeners(REJECTED_EVENT, rejectedEvent);
                    return;
                }
                this.notifyListeners(eventName, event);
            }
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, e, () -> "Caught and swallowed exception: " + e.getMessage());
        }
    }

    private void notifyListeners(EventName eventName, Event event) {
        List eventListeners = this.listeners.getOrDefault(eventName, new ArrayList());
        eventListeners.forEach(listener -> this.listenerNotificationExecutor.submit(() -> {
            try {
                listener.accept(event);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, t, () -> "Caught exception from listener: " + listener);
            }
        }));
    }
}

