/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public enum FirefoxDriverLogLevel {
    TRACE,
    DEBUG,
    CONFIG,
    INFO,
    WARN,
    ERROR,
    FATAL;

    private static final Map<Level, FirefoxDriverLogLevel> logLevelToGeckoLevelMap;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static FirefoxDriverLogLevel fromString(String text) {
        if (text != null) {
            for (FirefoxDriverLogLevel b : FirefoxDriverLogLevel.values()) {
                if (!text.equalsIgnoreCase(b.toString())) continue;
                return b;
            }
        }
        return null;
    }

    public static FirefoxDriverLogLevel fromLevel(Level level) {
        return logLevelToGeckoLevelMap.getOrDefault(level, DEBUG);
    }

    Map<String, String> toJson() {
        return Collections.singletonMap("level", this.toString());
    }

    static FirefoxDriverLogLevel fromJson(Map<String, String> json) {
        return FirefoxDriverLogLevel.fromString(json.get("level"));
    }

    static {
        logLevelToGeckoLevelMap = new ImmutableMap.Builder<Level, FirefoxDriverLogLevel>().put(Level.ALL, TRACE).put(Level.FINEST, TRACE).put(Level.FINER, TRACE).put(Level.FINE, DEBUG).put(Level.CONFIG, CONFIG).put(Level.INFO, INFO).put(Level.WARNING, WARN).put(Level.SEVERE, ERROR).put(Level.OFF, FATAL).build();
    }
}

