/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Executable;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends FirefoxDriverService {
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";

    public GeckoDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public GeckoDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)new Builder().build();
    }

    static GeckoDriverService createDefaultService(Capabilities caps) {
        Builder builder = new Builder();
        Object binary = caps.getCapability("firefox_binary");
        if (binary != null) {
            FirefoxBinary actualBinary;
            if (binary instanceof FirefoxBinary) {
                actualBinary = (FirefoxBinary)binary;
            } else if (binary instanceof String) {
                actualBinary = new FirefoxBinary(new File(String.valueOf(binary)));
            } else {
                throw new IllegalArgumentException("Expected binary to be a string or a binary: " + binary);
            }
            builder.usingFirefoxBinary(actualBinary);
        }
        return (GeckoDriverService)builder.build();
    }

    @Override
    protected void waitUntilAvailable() {
        PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected boolean hasShutdownEndpoint() {
        return false;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends FirefoxDriverService.Builder<GeckoDriverService, Builder> {
        private FirefoxBinary firefoxBinary;

        @Override
        protected boolean isLegacy() {
            return false;
        }

        @Override
        public int score(Capabilities capabilities) {
            if (capabilities.getCapability("marionette") != null && !capabilities.is("marionette")) {
                return 0;
            }
            int score = 0;
            if ("firefox".equals(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("moz:firefoxOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder usingFirefoxBinary(FirefoxBinary firefoxBinary) {
            Require.nonNull("Firefox binary", firefoxBinary);
            GeckoDriverService.checkExecutable(firefoxBinary.getFile());
            this.firefoxBinary = firefoxBinary;
            return this;
        }

        @Override
        protected FirefoxDriverService.Builder withOptions(FirefoxOptions options) {
            this.usingFirefoxBinary(options.getBinary());
            return this;
        }

        @Override
        protected File findDefaultExecutable() {
            return GeckoDriverService.findExecutable("geckodriver", GeckoDriverService.GECKO_DRIVER_EXE_PROPERTY, "https://github.com/mozilla/geckodriver", "https://github.com/mozilla/geckodriver/releases");
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.firefoxBinary != null) {
                args.add("-b");
                args.add(this.firefoxBinary.getPath());
            } else {
                Optional<Executable> executable = Optional.ofNullable(FirefoxBinary.locateFirefoxBinaryFromSystemProperty());
                executable.ifPresent(e -> {
                    args.add("-b");
                    args.add(e.getPath());
                });
            }
            return Collections.unmodifiableList(args);
        }

        @Override
        protected GeckoDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                GeckoDriverService service = new GeckoDriverService(exe, port, timeout, args, environment);
                String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
                if (firefoxLogFile != null) {
                    switch (firefoxLogFile) {
                        case "/dev/stdout": {
                            service.sendOutputTo(System.out);
                            break;
                        }
                        case "/dev/stderr": {
                            service.sendOutputTo(System.err);
                            break;
                        }
                        case "/dev/null": {
                            service.sendOutputTo(ByteStreams.nullOutputStream());
                            break;
                        }
                        default: {
                            service.sendOutputTo(new FileOutputStream(firefoxLogFile));
                            break;
                        }
                    }
                } else if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    service.sendOutputTo(System.err);
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

