/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.Dialect;

public class CreateSessionRequest {
    private final Set<Dialect> downstreamDialects;
    private final Capabilities capabilities;
    private final Map<String, Object> metadata;

    public CreateSessionRequest(Set<Dialect> downstreamDialects, Capabilities capabilities, Map<String, Object> metadata) {
        this.downstreamDialects = Collections.unmodifiableSet(new HashSet(Require.nonNull("Downstream dialects", downstreamDialects)));
        this.capabilities = ImmutableCapabilities.copyOf(Require.nonNull("Capabilities", capabilities));
        this.metadata = Collections.unmodifiableMap(new HashMap<String, Object>(Require.nonNull("Metadata", metadata)));
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.downstreamDialects;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    private static CreateSessionRequest fromJson(JsonInput input) {
        Set downstreamDialects = null;
        Capabilities capabilities = null;
        Map metadata = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    capabilities = (Capabilities)input.read((Type)((Object)Capabilities.class));
                    continue block10;
                }
                case "downstreamDialects": {
                    downstreamDialects = (Set)input.read(new TypeToken<Set<Dialect>>(){}.getType());
                    continue block10;
                }
                case "metadata": {
                    metadata = (Map)input.read(Json.MAP_TYPE);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreateSessionRequest(downstreamDialects, capabilities, metadata);
    }

    public String toString() {
        return String.format("<CreateSessionRequest with %s>", this.capabilities);
    }
}

