/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import org.openqa.selenium.internal.Require;

public class NodeId
implements Comparable<NodeId> {
    private final UUID uuid;

    public NodeId(UUID uuid) {
        this.uuid = Require.nonNull("Actual id", uuid);
    }

    public UUID toUuid() {
        return this.uuid;
    }

    @Override
    public int compareTo(NodeId that) {
        return Comparator.comparing(NodeId::toUuid).compare(this, that);
    }

    public String toString() {
        return this.uuid.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeId)) {
            return false;
        }
        NodeId that = (NodeId)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    private Object toJson() {
        return this.uuid;
    }

    private static NodeId fromJson(UUID id) {
        return new NodeId(id);
    }
}

