/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.DefaultSlotMatcher;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class Slot {
    private final SlotId id;
    private final Capabilities stereotype;
    private final Optional<Session> session;
    private final Instant lastStarted;
    private final SlotMatcher slotMatcher;

    public Slot(SlotId id, Capabilities stereotype, Instant lastStarted, Optional<Session> session) {
        this.id = Require.nonNull("Slot ID", id);
        this.stereotype = ImmutableCapabilities.copyOf(Require.nonNull("Stereotype", stereotype));
        this.lastStarted = Require.nonNull("Last started", lastStarted);
        this.session = Require.nonNull("Session", session);
        this.slotMatcher = new DefaultSlotMatcher();
    }

    public SlotId getId() {
        return this.id;
    }

    public Capabilities getStereotype() {
        return this.stereotype;
    }

    public Instant getLastStarted() {
        return this.lastStarted;
    }

    public Optional<Session> getSession() {
        return this.session;
    }

    public boolean isSupporting(Capabilities caps) {
        return this.slotMatcher.matches(this.getStereotype(), caps);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slot)) {
            return false;
        }
        Slot that = (Slot)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.stereotype, that.stereotype) && Objects.equals(this.session, that.session) && Objects.equals(this.lastStarted.toEpochMilli(), that.lastStarted.toEpochMilli());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.stereotype, this.session, this.lastStarted.toEpochMilli());
    }

    private static Slot fromJson(JsonInput input) {
        SlotId id = null;
        Capabilities stereotype = null;
        Instant lastStarted = null;
        Optional<Session> session = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            String name;
            switch (name = input.nextName()) {
                case "id": {
                    id = (SlotId)input.read((Type)((Object)SlotId.class));
                    continue block12;
                }
                case "lastStarted": {
                    lastStarted = (Instant)input.read((Type)((Object)Instant.class));
                    continue block12;
                }
                case "session": {
                    session = Optional.ofNullable((Session)input.read((Type)((Object)Session.class)));
                    continue block12;
                }
                case "stereotype": {
                    stereotype = (Capabilities)input.read((Type)((Object)Capabilities.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Slot(id, stereotype, lastStarted, session);
    }
}

