/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

class AddNode
implements HttpHandler {
    private final Tracer tracer;
    private final Distributor distributor;
    private final Json json;
    private final HttpClient.Factory httpFactory;
    private final Secret registrationSecret;

    AddNode(Tracer tracer, Distributor distributor, Json json, HttpClient.Factory httpFactory, Secret registrationSecret) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.distributor = Require.nonNull("Distributor", distributor);
        this.json = Require.nonNull("Json converter", json);
        this.httpFactory = Require.nonNull("HTTP Factory", httpFactory);
        this.registrationSecret = Require.nonNull("Registration secret", registrationSecret);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        NodeStatus status = (NodeStatus)this.json.toType(Contents.string(req), (Type)((Object)NodeStatus.class));
        RemoteNode node = new RemoteNode(this.tracer, this.httpFactory, status.getId(), status.getUri(), this.registrationSecret, status.getSlots().stream().map(Slot::getStereotype).collect(Collectors.toSet()));
        this.distributor.add(node);
        return new HttpResponse();
    }
}

