/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.distributor.AddNode;
import org.openqa.selenium.grid.distributor.DrainNode;
import org.openqa.selenium.grid.distributor.GetDistributorStatus;
import org.openqa.selenium.grid.distributor.RemoveNode;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class Distributor
implements HasReadyState,
Predicate<HttpRequest>,
Routable {
    private static final Logger LOG = Logger.getLogger(Distributor.class.getName());
    private final Route routes;
    protected final Tracer tracer;
    private final SlotSelector slotSelector;
    private final SessionMap sessions;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    protected Distributor(Tracer tracer, HttpClient.Factory httpClientFactory, SlotSelector slotSelector, SessionMap sessions, Secret registrationSecret) {
        this.tracer = Require.nonNull("Tracer", tracer);
        Require.nonNull("HTTP client factory", httpClientFactory);
        this.slotSelector = Require.nonNull("Slot selector", slotSelector);
        this.sessions = Require.nonNull("Session map", sessions);
        Require.nonNull("Registration secret", registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.post("/se/grid/distributor/node").to(() -> new AddNode(tracer, this, json, httpClientFactory, registrationSecret)).with(requiresSecret), new Routable[]{Route.post("/se/grid/distributor/node/{nodeId}/drain").to(params -> new DrainNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with(requiresSecret), Route.delete("/se/grid/distributor/node/{nodeId}").to(params -> new RemoveNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with(requiresSecret), Route.get("/se/grid/distributor/status").to(() -> new GetDistributorStatus(this)).with(new SpanDecorator(tracer, req -> "distributor.status"))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Either<SessionNotCreatedException, CreateSessionResponse> newSession(SessionRequest request) throws SessionNotCreatedException {
        Either<SessionNotCreatedException, CreateSessionResponse> either;
        Require.nonNull("Requests to process", request);
        HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
        try (Span span = this.tracer.getCurrentContext().createSpan("distributor.create_session_response");){
            Either<SessionNotCreatedException, CreateSessionResponse> selected;
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue(this.getClass().getName()));
            Iterator<Capabilities> iterator = request.getDesiredCapabilities().iterator();
            attributeMap.put("request.payload", EventAttribute.setValue(request.getDesiredCapabilities().toString()));
            String sessionReceivedMessage = "Session request received by the distributor";
            span.addEvent(sessionReceivedMessage, attributeMap);
            LOG.info(String.format("%s: \n %s", sessionReceivedMessage, request.getDesiredCapabilities()));
            if (!iterator.hasNext()) {
                SessionNotCreatedException exception = new SessionNotCreatedException("No capabilities found in session request payload");
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue("Unable to create session. No capabilities found: " + exception.getMessage()));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                Either<SessionNotCreatedException, CreateSessionResponse> either2 = Either.left(exception);
                return either2;
            }
            CreateSessionRequest firstRequest = new CreateSessionRequest(request.getDownstreamDialects(), iterator.next(), ImmutableMap.of("span", span));
            Lock writeLock = this.lock.writeLock();
            writeLock.lock();
            try {
                ImmutableSet<NodeStatus> model = ImmutableSet.copyOf(this.getAvailableNodes());
                boolean hostsWithCaps = model.stream().anyMatch(nodeStatus -> nodeStatus.hasCapability(firstRequest.getCapabilities()));
                if (!hostsWithCaps) {
                    String errorMessage = String.format("No Node supports the required capabilities: %s", request.getDesiredCapabilities().stream().map(Object::toString).collect(Collectors.joining(", ")));
                    SessionNotCreatedException exception = new SessionNotCreatedException(errorMessage);
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.ABORTED);
                    Tags.EXCEPTION.accept(attributeMap, exception);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue("Unable to create session: " + exception.getMessage()));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either<SessionNotCreatedException, CreateSessionResponse> either3 = Either.left(exception);
                    return either3;
                }
                Set<SlotId> slotIds = this.slotSelector.selectSlot(firstRequest.getCapabilities(), model);
                if (!slotIds.isEmpty()) {
                    selected = this.reserve(slotIds.iterator().next(), firstRequest);
                } else {
                    String errorMessage = String.format("Unable to find provider for session: %s", request.getDesiredCapabilities().stream().map(Object::toString).collect(Collectors.joining(", ")));
                    RetrySessionRequestException exception = new RetrySessionRequestException(errorMessage);
                    selected = Either.left(exception);
                }
            }
            finally {
                writeLock.unlock();
            }
            if (selected.isRight()) {
                CreateSessionResponse sessionResponse = selected.right();
                this.sessions.add(sessionResponse.getSession());
                SessionId sessionId = sessionResponse.getSession().getId();
                Capabilities caps = sessionResponse.getSession().getCapabilities();
                String sessionUri = sessionResponse.getSession().getUri().toString();
                RemoteTags.SESSION_ID.accept(span, sessionId);
                RemoteTags.CAPABILITIES.accept(span, caps);
                RemoteTags.SESSION_ID_EVENT.accept(attributeMap, sessionId);
                RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, caps);
                span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                attributeMap.put(AttributeKey.SESSION_URI.getKey(), EventAttribute.setValue(sessionUri));
                String sessionCreatedMessage = "Session created by the distributor";
                span.addEvent(sessionCreatedMessage, attributeMap);
                LOG.info(String.format("%s. Id: %s, Caps: %s", sessionCreatedMessage, sessionId, caps));
                Either<SessionNotCreatedException, CreateSessionResponse> either4 = Either.right(sessionResponse);
                return either4;
            }
            Either<SessionNotCreatedException, CreateSessionResponse> either5 = selected;
            return either5;
        }
    }

    public abstract Distributor add(Node var1);

    public abstract boolean drain(NodeId var1);

    public abstract void remove(NodeId var1);

    public abstract DistributorStatus getStatus();

    protected abstract Set<NodeStatus> getAvailableNodes();

    protected abstract Either<SessionNotCreatedException, CreateSessionResponse> reserve(SlotId var1, CreateSessionRequest var2);

    @Override
    public boolean test(HttpRequest httpRequest) {
        return this.matches(httpRequest);
    }

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.routes.execute(req);
    }
}

