/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.GridData;
import org.openqa.selenium.grid.graphql.SessionData;
import org.openqa.selenium.grid.graphql.Types;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class GraphqlHandler
implements HttpHandler {
    public static final String GRID_SCHEMA = "/org/openqa/selenium/grid/graphql/selenium-grid-schema.graphqls";
    public static final Json JSON = new Json();
    private final Tracer tracer;
    private final Distributor distributor;
    private final NewSessionQueuer newSessionQueuer;
    private final URI publicUri;
    private final String version;
    private final GraphQL graphQl;

    public GraphqlHandler(Tracer tracer, Distributor distributor, NewSessionQueuer newSessionQueuer, URI publicUri, String version) {
        this.distributor = Require.nonNull("Distributor", distributor);
        this.newSessionQueuer = Require.nonNull("NewSessionQueuer", newSessionQueuer);
        this.publicUri = Require.nonNull("Uri", publicUri);
        this.version = Require.nonNull("GridVersion", version);
        this.tracer = Require.nonNull("Tracer", tracer);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(this.buildTypeDefinitionRegistry(), this.buildRuntimeWiring());
        Cache cache = CacheBuilder.newBuilder().maximumSize(1024L).build();
        this.graphQl = GraphQL.newGraphQL(schema).preparsedDocumentProvider((executionInput, computeFunction) -> {
            try {
                return cache.get(executionInput.getQuery(), () -> (PreparsedDocumentEntry)computeFunction.apply(executionInput));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() != null) {
                    throw new RuntimeException(e.getCause());
                }
                throw new RuntimeException(e);
            }
        }).build();
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        if (req.getMethod() == HttpMethod.OPTIONS) {
            return new HttpResponse();
        }
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "grid.status");){
            Map inputs = (Map)JSON.toType(Contents.string(req), Json.MAP_TYPE);
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue(this.getClass().getName()));
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            if (!(inputs.get("query") instanceof String)) {
                HttpResponse response = (HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.utf8String("Unable to find query"));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue("Unable to find query"));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            String query = (String)inputs.get("query");
            HashMap<String, Object> variables = inputs.get("variables") instanceof Map ? (Map)inputs.get("variables") : new HashMap();
            ExecutionInput executionInput = ExecutionInput.newExecutionInput(query).variables(variables).build();
            ExecutionResult result = this.graphQl.execute(executionInput);
            if (result.isDataPresent()) {
                HttpResponse response = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent((Supplier)Contents.utf8String(JSON.toJson(result.toSpecification())));
                Tags.HTTP_RESPONSE.accept(span, response);
                Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
                span.addEvent("Graphql query executed", attributeMap);
                HttpResponse httpResponse = response;
                return httpResponse;
            }
            HttpResponse response = (HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.utf8String(JSON.toJson(result.getErrors())));
            Tags.HTTP_RESPONSE.accept(span, response);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, response);
            attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue("Error while executing the query"));
            span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }

    private RuntimeWiring buildRuntimeWiring() {
        GridData gridData = new GridData(this.distributor, this.newSessionQueuer, this.publicUri, this.version);
        return RuntimeWiring.newRuntimeWiring().scalar(Types.Uri).scalar(Types.Url).type("GridQuery", typeWiring -> typeWiring.dataFetcher("grid", gridData).dataFetcher("sessionsInfo", gridData).dataFetcher("nodesInfo", gridData).dataFetcher("session", new SessionData(this.distributor))).build();
    }

    private TypeDefinitionRegistry buildTypeDefinitionRegistry() {
        TypeDefinitionRegistry typeDefinitionRegistry;
        block8: {
            InputStream stream = this.getClass().getResourceAsStream(GRID_SCHEMA);
            try {
                typeDefinitionRegistry = new SchemaParser().parse(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return typeDefinitionRegistry;
    }
}

