/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.Node;
import org.openqa.selenium.grid.graphql.OsInfo;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Grid {
    private static final Json JSON = new Json();
    private final URI uri;
    private final Supplier<DistributorStatus> distributorStatus;
    private final List<Set<Capabilities>> queueInfoList;
    private final String version;

    public Grid(Distributor distributor, NewSessionQueuer newSessionQueuer, URI uri, String version) {
        Require.nonNull("Distributor", distributor);
        this.uri = Require.nonNull("Grid's public URI", uri);
        NewSessionQueuer sessionQueuer = Require.nonNull("NewSessionQueuer", newSessionQueuer);
        this.queueInfoList = sessionQueuer.getQueueContents();
        this.distributorStatus = Suppliers.memoize(distributor::getStatus);
        this.version = Require.nonNull("Grid's version", version);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Node> getNodes() {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        for (NodeStatus status : this.distributorStatus.get().getNodes()) {
            HashMap<Capabilities, Integer> stereotypes = new HashMap<Capabilities, Integer>();
            HashMap<org.openqa.selenium.grid.data.Session, Slot> sessions = new HashMap<org.openqa.selenium.grid.data.Session, Slot>();
            for (Slot slot : status.getSlots()) {
                slot.getSession().ifPresent(session -> sessions.put((org.openqa.selenium.grid.data.Session)session, slot));
                int count = stereotypes.getOrDefault(slot.getStereotype(), 0);
                stereotypes.put(slot.getStereotype(), ++count);
            }
            OsInfo osInfo = new OsInfo(status.getOsInfo().get("arch"), status.getOsInfo().get("name"), status.getOsInfo().get("version"));
            toReturn.add(new Node(status.getId(), status.getUri(), status.getAvailability(), status.getMaxSessionCount(), status.getSlots().size(), stereotypes, sessions, status.getVersion(), osInfo));
        }
        return toReturn.build();
    }

    public int getNodeCount() {
        return this.distributorStatus.get().getNodes().size();
    }

    public int getSessionCount() {
        return this.distributorStatus.get().getNodes().stream().map(NodeStatus::getSlots).flatMap(Collection::stream).filter(slot -> slot.getSession().isPresent()).mapToInt(slot -> 1).sum();
    }

    public int getTotalSlots() {
        return this.distributorStatus.get().getNodes().stream().mapToInt(status -> status.getSlots().size()).sum();
    }

    public int getMaxSession() {
        return this.distributorStatus.get().getNodes().stream().mapToInt(NodeStatus::getMaxSessionCount).sum();
    }

    public int getSessionQueueSize() {
        return this.queueInfoList.size();
    }

    public List<String> getSessionQueueRequests() {
        return this.queueInfoList.stream().map(set -> set.isEmpty() ? new ImmutableCapabilities() : (Capabilities)set.iterator().next()).map(JSON::toJson).collect(Collectors.toList());
    }

    public List<Session> getSessions() {
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (NodeStatus status : this.distributorStatus.get().getNodes()) {
            for (Slot slot : status.getSlots()) {
                if (!slot.getSession().isPresent()) continue;
                org.openqa.selenium.grid.data.Session session = slot.getSession().get();
                sessions.add(new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), status.getId().toString(), status.getUri(), slot));
            }
        }
        return sessions;
    }
}

