/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class BrowserOptionsMutator
implements Function<Capabilities, Capabilities> {
    private static final ImmutableMap<String, String> BROWSER_OPTIONS = ImmutableMap.of("chrome", "goog:chromeOptions", "firefox", "moz:firefoxOptions", "microsoftedge", "ms:edgeOptions");
    private final Capabilities slotStereotype;

    public BrowserOptionsMutator(Capabilities slotStereotype) {
        this.slotStereotype = slotStereotype;
    }

    @Override
    public Capabilities apply(Capabilities capabilities) {
        if (!Objects.equals(this.slotStereotype.getBrowserName(), capabilities.getBrowserName())) {
            return capabilities;
        }
        String browserName = capabilities.getBrowserName().toLowerCase();
        if (!BROWSER_OPTIONS.containsKey(browserName)) {
            return capabilities;
        }
        String options = BROWSER_OPTIONS.get(browserName);
        if (!this.slotStereotype.asMap().containsKey(options)) {
            return capabilities;
        }
        Map stereotypeOptions = (Map)this.slotStereotype.asMap().get(options);
        HashMap<String, Object> toReturn = new HashMap<String, Object>(capabilities.asMap());
        if (!toReturn.containsKey(options)) {
            toReturn.put(options, stereotypeOptions);
            return new ImmutableCapabilities(toReturn);
        }
        Map capsOptions = (Map)toReturn.get(options);
        stereotypeOptions.forEach((key, value) -> {
            if (!capsOptions.containsKey(key)) {
                capsOptions.put(key, value);
            }
        });
        return new ImmutableCapabilities(toReturn);
    }
}

