/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionmap.httpd.DefaultSessionMapConfig;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

@AutoService(value={CliCommand.class})
public class SessionMapServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(SessionMapServer.class.getName());

    @Override
    public String getName() {
        return "sessions";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the session map in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of(StandardGridRoles.EVENT_BUS_ROLE, StandardGridRoles.HTTPD_ROLE, StandardGridRoles.SESSION_MAP_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "sessions";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultSessionMapConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        Require.nonNull("Config", config);
        SessionMapOptions sessionMapOptions = new SessionMapOptions(config);
        SessionMap sessions = sessionMapOptions.getSessionMap();
        return new TemplateGridServerCommand.Handlers(Route.combine(sessions, Route.get("/status").to(() -> req -> (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("ready", true, "message", "Session map is ready."))))), Route.get("/readyz").to(() -> req -> new HttpResponse().setStatus(204))), null);
    }

    @Override
    protected void execute(Config config) {
        Server<?> server = this.asServer(config);
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium session map %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

