/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ClearSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueuer newSessionQueuer;

    ClearSessionQueue(Tracer tracer, NewSessionQueuer newSessionQueuer) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueuer = Require.nonNull("New Session Queuer", newSessionQueuer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse execute(HttpRequest req) {
        Tags.HTTP_REQUEST.accept(span, req);
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueuer.clear");){
            int value = this.newSessionQueuer.clearQueue();
            span.setAttribute("cleared", value);
            HttpResponse response = new HttpResponse();
            if (value != 0) {
                response.setContent((Supplier)Contents.asJson(ImmutableMap.of("value", value, "message", "Cleared the new session request queue", "cleared_requests", value)));
            } else {
                response.setContent((Supplier)Contents.asJson(ImmutableMap.of("value", value, "message", "New session request queue empty. Nothing to clear.")));
            }
            span.setAttribute("requests.cleared", value);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

