/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.NewSessionErrorResponse;
import org.openqa.selenium.grid.data.NewSessionRejectedEvent;
import org.openqa.selenium.grid.data.NewSessionRequest;
import org.openqa.selenium.grid.data.NewSessionResponse;
import org.openqa.selenium.grid.data.NewSessionResponseEvent;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;

public class GetNewSessionResponse {
    private static final Logger LOG = Logger.getLogger(GetNewSessionResponse.class.getName());
    private static final Map<RequestId, NewSessionRequest> knownRequests = new ConcurrentHashMap<RequestId, NewSessionRequest>();
    private final EventBus bus;
    private final NewSessionQueue sessionRequests;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public GetNewSessionResponse(EventBus bus, NewSessionQueue sessionRequests) {
        this.bus = Require.nonNull("Event bus", bus);
        this.sessionRequests = Require.nonNull("New Session Request Queue", sessionRequests);
        this.bus.addListener(NewSessionResponseEvent.listener(this::setResponse));
        this.bus.addListener(NewSessionRejectedEvent.listener(this::setErrorResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponse(NewSessionResponse sessionResponse) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            RequestId id = sessionResponse.getRequestId();
            Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(knownRequests.get(id));
            if (sessionRequest.isPresent()) {
                NewSessionRequest request = sessionRequest.get();
                request.setSessionResponse((HttpResponse)new HttpResponse().setContent((Supplier)Contents.bytes(sessionResponse.getDownstreamEncodedResponse())));
                request.getLatch().countDown();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorResponse(NewSessionErrorResponse sessionResponse) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            RequestId id = sessionResponse.getRequestId();
            Optional<NewSessionRequest> sessionRequest = Optional.ofNullable(knownRequests.get(id));
            if (sessionRequest.isPresent()) {
                NewSessionRequest request = sessionRequest.get();
                request.setSessionResponse(this.internalErrorResponse(sessionResponse.getMessage()));
                request.getLatch().countDown();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse add(SessionRequest request) {
        Require.nonNull("New Session request", request);
        CountDownLatch latch = new CountDownLatch(1);
        RequestId requestId = request.getRequestId();
        NewSessionRequest requestIdentifier = new NewSessionRequest(requestId, latch);
        knownRequests.put(requestId, requestIdentifier);
        if (!this.sessionRequests.offerLast(request)) {
            return this.internalErrorResponse("Session request could not be created. Error while adding to the session queue.");
        }
        try {
            latch.await();
            HttpResponse httpResponse = requestIdentifier.getSessionResponse();
            return httpResponse;
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "The thread waiting for new session response interrupted. {0}", e.getMessage());
            Thread.currentThread().interrupt();
            HttpResponse httpResponse = this.internalErrorResponse("Session request could not be created. Error while processing the session request.");
            return httpResponse;
        }
        finally {
            this.removeRequest(requestId);
        }
    }

    private HttpResponse internalErrorResponse(String message) {
        return (HttpResponse)new HttpResponse().setStatus(500).setContent((Supplier)Contents.asJson(Collections.singletonMap("value", Collections.singletonMap("message", message))));
    }

    private void removeRequest(RequestId id) {
        knownRequests.remove(id);
    }
}

