/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Collections;
import java.util.function.Supplier;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GetSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueuer newSessionQueuer;

    GetSessionQueue(Tracer tracer, NewSessionQueuer newSessionQueuer) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueuer = Require.nonNull("New Session Queuer", newSessionQueuer);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueue.contents");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpResponse response = (HttpResponse)new HttpResponse().setContent((Supplier)Contents.asJson(Collections.singletonMap("value", this.newSessionQueuer.getQueueContents())));
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

