/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Optional;
import java.util.function.Supplier;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoveFromSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueuer newSessionQueuer;
    private final RequestId id;

    RemoveFromSessionQueue(Tracer tracer, NewSessionQueuer newSessionQueuer, RequestId id) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.newSessionQueuer = Require.nonNull("New Session Queuer", newSessionQueuer);
        this.id = id;
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf(this.tracer, req, "sessionqueuer.remove");){
            Tags.HTTP_REQUEST.accept(span, req);
            Optional<SessionRequest> sessionRequest = this.newSessionQueuer.remove(this.id);
            HttpResponse response = new HttpResponse();
            if (sessionRequest.isPresent()) {
                HttpResponse httpResponse = (HttpResponse)response.setContent((Supplier)Contents.asJson(sessionRequest));
                return httpResponse;
            }
            response.setStatus(204);
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

