/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpRequest;

public class SessionRequest {
    private static final Type SET_OF_CAPABILITIES = new TypeToken<Set<Capabilities>>(){}.getType();
    private static final Type SET_OF_DIALECTS = new TypeToken<Set<Dialect>>(){}.getType();
    private final RequestId requestId;
    private final Instant enqueued;
    private final Set<Capabilities> desiredCapabilities;
    private final Set<Dialect> downstreamDialects;

    public SessionRequest(RequestId requestId, HttpRequest request, Instant enqueued) {
        this.requestId = Require.nonNull("Request ID", requestId);
        this.enqueued = Require.nonNull("Enqueud time", enqueued);
        Require.nonNull("Request", request);
        try (NewSessionPayload payload = NewSessionPayload.create(Contents.reader(request));){
            this.desiredCapabilities = payload.stream().collect(Collectors.toSet());
            this.downstreamDialects = payload.getDownstreamDialects();
        }
    }

    public SessionRequest(RequestId requestId, Instant enqueued, Set<Dialect> downstreamDialects, Set<Capabilities> desiredCapabilities) {
        this.requestId = Require.nonNull("Request ID", requestId);
        this.enqueued = Require.nonNull("Enqueud time", enqueued);
        this.downstreamDialects = Require.nonNull("Downstream dialects", downstreamDialects);
        this.desiredCapabilities = Require.nonNull("Capabilities", desiredCapabilities);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Set<Capabilities> getDesiredCapabilities() {
        return this.desiredCapabilities;
    }

    public Set<Dialect> getDownstreamDialects() {
        return this.downstreamDialects;
    }

    public Instant getEnqueued() {
        return this.enqueued;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of("requestId", this.requestId, "enqueued", this.enqueued, "dialects", this.downstreamDialects, "capabilities", this.desiredCapabilities);
    }

    private static SessionRequest fromJson(JsonInput input) {
        RequestId id = null;
        Instant enqueued = null;
        Set capabilities = null;
        Set dialects = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "capabilities": {
                    capabilities = (Set)input.read(SET_OF_CAPABILITIES);
                    continue block12;
                }
                case "dialects": {
                    dialects = (Set)input.read(SET_OF_DIALECTS);
                    continue block12;
                }
                case "enqueued": {
                    enqueued = (Instant)input.read((Type)((Object)Instant.class));
                    continue block12;
                }
                case "requestId": {
                    id = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SessionRequest(id, enqueued, dialects, capabilities);
    }
}

